/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.serialization;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Objects;
import java.util.Optional;
import schemacrawler.schema.Catalog;
import schemacrawler.schemacrawler.BaseCatalogDecorator;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.integration.serialization.SerializableCatalog;

public final class JavaSerializedCatalog
extends BaseCatalogDecorator
implements SerializableCatalog {
    private static final long serialVersionUID = 5314326260124511414L;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Catalog readCatalog(InputStream in) throws SchemaCrawlerException {
        Objects.requireNonNull(in, "No input stream provided");
        try (ObjectInputStream objIn = new ObjectInputStream(in);){
            Catalog catalog = (Catalog)objIn.readObject();
            return catalog;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new SchemaCrawlerException("Cannot deserialize catalog", (Throwable)e);
        }
    }

    public JavaSerializedCatalog(Catalog catalog) {
        super(catalog);
    }

    public JavaSerializedCatalog(InputStream in) throws SchemaCrawlerException {
        this(JavaSerializedCatalog.readCatalog(in));
    }

    public final <T> Optional<T> lookupAttribute(String name) {
        return Optional.of(this.getAttribute(name));
    }

    @Override
    public void save(OutputStream out) throws SchemaCrawlerException {
        Objects.requireNonNull(out, "No output stream provided");
        try (ObjectOutputStream objOut = new ObjectOutputStream(out);){
            objOut.writeObject(this.catalog);
        }
        catch (IOException e) {
            throw new SchemaCrawlerException("Could not serialize catalog", (Throwable)e);
        }
    }
}

