/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.thymeleaf;

import java.io.Writer;
import java.nio.charset.Charset;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.templateresolver.AbstractConfigurableTemplateResolver;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.FileTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresolver.UrlTemplateResolver;
import schemacrawler.tools.executable.BaseSchemaCrawlerCommand;

public final class ThymeleafRenderer
extends BaseSchemaCrawlerCommand {
    static final String COMMAND = "thymeleaf";

    public ThymeleafRenderer() {
        super(COMMAND);
    }

    public void checkAvailibility() throws Exception {
    }

    public final void execute() throws Exception {
        this.checkCatalog();
        Context context = new Context();
        context.setVariable("catalog", (Object)this.catalog);
        context.setVariable("identifiers", (Object)this.identifiers);
        TemplateEngine templateEngine = new TemplateEngine();
        Charset inputCharset = this.outputOptions.getInputCharset();
        FileTemplateResolver fileResolver = new FileTemplateResolver();
        fileResolver.setCheckExistence(true);
        templateEngine.addTemplateResolver(this.configure((AbstractConfigurableTemplateResolver)fileResolver, inputCharset));
        ClassLoaderTemplateResolver classpathResolver = new ClassLoaderTemplateResolver();
        classpathResolver.setCheckExistence(true);
        templateEngine.addTemplateResolver(this.configure((AbstractConfigurableTemplateResolver)classpathResolver, inputCharset));
        UrlTemplateResolver urlResolver = new UrlTemplateResolver();
        urlResolver.setCheckExistence(true);
        templateEngine.addTemplateResolver(this.configure((AbstractConfigurableTemplateResolver)urlResolver, inputCharset));
        String templateLocation = this.outputOptions.getOutputFormatValue();
        try (Writer writer = this.outputOptions.openNewOutputWriter();){
            templateEngine.process(templateLocation, (IContext)context, writer);
        }
    }

    public boolean usesConnection() {
        return true;
    }

    private ITemplateResolver configure(AbstractConfigurableTemplateResolver templateResolver, Charset inputEncoding) {
        templateResolver.setCharacterEncoding(inputEncoding.name());
        templateResolver.setTemplateMode("HTML5");
        return templateResolver;
    }
}

