/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.loader.counts;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.loader.counts.TableRowCountsUtility;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.IdentifierQuotingStrategy;
import schemacrawler.schemacrawler.Identifiers;
import schemacrawler.schemacrawler.IdentifiersBuilder;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.QueryUtility;
import us.fatehi.utility.datasource.DatabaseConnectionSource;
import us.fatehi.utility.string.StringFormat;

public final class TableRowCountsRetriever {
    private static final Logger LOGGER = Logger.getLogger(TableRowCountsRetriever.class.getName());
    private final DatabaseConnectionSource dataSource;
    private final Catalog catalog;

    public TableRowCountsRetriever(DatabaseConnectionSource dataSource, Catalog catalog) throws SQLException {
        this.dataSource = Objects.requireNonNull(dataSource, "No database connection source provided");
        this.catalog = Objects.requireNonNull(catalog, "No catalog provided");
    }

    public void retrieveTableRowCounts() {
        Identifiers identifiers;
        Throwable throwable;
        Connection connection;
        try {
            connection = (Connection)this.dataSource.get();
            throwable = null;
            try {
                identifiers = IdentifiersBuilder.builder().fromConnection(connection).withIdentifierQuotingStrategy(IdentifierQuotingStrategy.quote_all).toOptions();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (connection != null) {
                    if (throwable != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        connection.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "No connection provided", e);
            return;
        }
        try {
            connection = (Connection)this.dataSource.get();
            throwable = null;
            try {
                Query query = new Query("schemacrawler.table.row_counts", "SELECT COUNT(*) FROM ${table}");
                ArrayList allTables = new ArrayList(this.catalog.getTables());
                for (Table table : allTables) {
                    try {
                        long count = QueryUtility.executeForLong((Query)query, (Connection)connection, (Table)table, (Identifiers)identifiers);
                        TableRowCountsUtility.addRowCountToTable(table, count);
                    }
                    catch (SQLException e) {
                        LOGGER.log(Level.WARNING, e, (Supplier<String>)new StringFormat("Could not get count for table <%s>", new Object[]{table}));
                    }
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (connection != null) {
                    if (throwable != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        connection.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Could not get table row counts", e);
        }
    }
}

