SELECT
  CURRENT_DATABASE()::INFORMATION_SCHEMA.SQL_IDENTIFIER AS TABLE_CATALOG,
  NAMESPACES.NSPNAME::INFORMATION_SCHEMA.SQL_IDENTIFIER AS TABLE_SCHEMA,
  TABLES.RELNAME::INFORMATION_SCHEMA.SQL_IDENTIFIER AS TABLE_NAME,
  TABLES.*
FROM
  PG_CATALOG.PG_CLASS TABLES
  INNER JOIN PG_CATALOG.PG_NAMESPACE NAMESPACES
    ON TABLES.RELNAMESPACE = NAMESPACES.OID
WHERE
  NAMESPACES.NSPNAME NOT IN ('pg_catalog', 'information_schema')
  AND NAMESPACES.NSPNAME !~ '^pg_toast'
  AND TABLES.RELKIND IN ('r', 'v')
