/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.server.postgresql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.plugin.EnumDataTypeHelper;
import schemacrawler.plugin.EnumDataTypeInfo;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.QueryUtility;
import us.fatehi.utility.database.DatabaseUtility;
import us.fatehi.utility.string.StringFormat;

public class PostgreSQLEnumDataTypeHelper
implements EnumDataTypeHelper {
    private static final Logger LOGGER = Logger.getLogger(PostgreSQLEnumDataTypeHelper.class.getName());
    private final Set<ColumnDataType> visitedDataTypes = ConcurrentHashMap.newKeySet();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<String> getEnumValues(ColumnDataType columnDataType, Connection connection) {
        Objects.requireNonNull(columnDataType, "No column provided");
        Query query = QueryUtility.getQueryFromResource((String)"Get enum values for column data type", (String)"/postgresql.information_schema/PG_ENUM.sql");
        try (Statement statement = connection.createStatement();){
            List enumValues;
            ResultSet resultSet = QueryUtility.executeAgainstColumnDataType((Query)query, (Statement)statement, (ColumnDataType)columnDataType);
            List list = enumValues = DatabaseUtility.readResultsVector((ResultSet)resultSet, (int)4);
            return list;
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, e, (Supplier<String>)new StringFormat("Error executing <%s>", new Object[]{query}));
            return new ArrayList<String>();
        }
    }

    public EnumDataTypeInfo getEnumDataTypeInfo(Column column, ColumnDataType columnDataType, Connection connection) {
        Objects.requireNonNull(columnDataType, "No column data type provided");
        if (this.visitedDataTypes.contains(columnDataType)) {
            EnumDataTypeInfo.EnumDataTypeTypes enumType = columnDataType.isEnumerated() ? EnumDataTypeInfo.EnumDataTypeTypes.enumerated_data_type : EnumDataTypeInfo.EnumDataTypeTypes.not_enumerated;
            return new EnumDataTypeInfo(enumType, columnDataType.getEnumValues());
        }
        try {
            DatabaseUtility.checkConnection((Connection)connection);
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Could not obtain enumerated column values", e);
        }
        List<String> enumValues = PostgreSQLEnumDataTypeHelper.getEnumValues(columnDataType, connection);
        this.visitedDataTypes.add(columnDataType);
        EnumDataTypeInfo.EnumDataTypeTypes enumType = enumValues.isEmpty() ? EnumDataTypeInfo.EnumDataTypeTypes.not_enumerated : EnumDataTypeInfo.EnumDataTypeTypes.enumerated_data_type;
        return new EnumDataTypeInfo(enumType, enumValues);
    }
}

