/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.timesten;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schemacrawler.DatabaseServerType;
import schemacrawler.tools.databaseconnector.DatabaseConnector;
import schemacrawler.tools.executable.commandline.PluginCommand;
import us.fatehi.utility.datasource.DatabaseConnectionSourceBuilder;

public final class TimesTenDatabaseConnector
extends DatabaseConnector {
    private static final Logger LOGGER = Logger.getLogger(TimesTenDatabaseConnector.class.getName());

    public TimesTenDatabaseConnector() throws IOException {
        super(new DatabaseServerType("timesten", "Oracle TimesTen"), url -> url != null && url.startsWith("jdbc:timesten:"), (informationSchemaViewsBuilder, connection) -> informationSchemaViewsBuilder.fromResourceFolder("/timesten.information_schema"), (schemaRetrievalOptionsBuilder, connection) -> {}, limitOptionsBuilder -> {}, () -> DatabaseConnectionSourceBuilder.builder((String)"jdbc:timesten:client:dsn=${database};TTC_SERVER=${host};TCP_PORT=${port};").withDefaultPort(53397));
        LOGGER.log(Level.INFO, "Loaded commandline for Oracle TimesTen");
    }

    public PluginCommand getHelpCommand() {
        PluginCommand pluginCommand = super.getHelpCommand();
        pluginCommand.addOption("server", String.class, new String[]{"--server=timesten%nLoads SchemaCrawler plug-in for Oracle TimesTen"}).addOption("host", String.class, new String[]{"Host name%nOptional, defaults to localhost"}).addOption("port", Integer.class, new String[]{"Port number%nOptional, defaults to 53397"}).addOption("database", String.class, new String[]{"DSN name"});
        return pluginCommand;
    }
}

