/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.analysis.associations;

import com.annimon.stream.function.Supplier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.logging.Level;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnReference;
import schemacrawler.schema.Table;
import schemacrawler.tools.analysis.associations.ColumnMatchKeysMap;
import schemacrawler.tools.analysis.associations.ForeignKeys;
import schemacrawler.tools.analysis.associations.TableCandidateKeys;
import schemacrawler.tools.analysis.associations.TableMatchKeys;
import schemacrawler.tools.analysis.associations.WeakAssociation;
import schemacrawler.tools.analysis.associations.WeakAssociationForeignKey;
import schemacrawler.tools.analysis.associations.WeakAssociationsUtility;
import schemacrawler.utility.MetaDataUtility;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;

final class WeakAssociationsAnalyzer {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger((String)WeakAssociationsAnalyzer.class.getName());
    private final List<Table> tables;
    private final Collection<WeakAssociationForeignKey> weakAssociations;

    WeakAssociationsAnalyzer(List<Table> tables) {
        this.tables = Objects.requireNonNull(tables, "No tables provided");
        this.weakAssociations = new TreeSet<WeakAssociationForeignKey>();
    }

    Collection<WeakAssociationForeignKey> analyzeTables() {
        if (this.tables.size() < 2) {
            return Collections.emptySet();
        }
        this.findWeakAssociations(this.tables);
        return this.weakAssociations;
    }

    private void addWeakAssociation(WeakAssociation weakAssociation) {
        String weakFkName = MetaDataUtility.constructForeignKeyName((Column)weakAssociation.getPrimaryKeyColumn(), (Column)weakAssociation.getForeignKeyColumn());
        WeakAssociationForeignKey weakFk = new WeakAssociationForeignKey(weakFkName);
        weakFk.add(weakAssociation);
        this.weakAssociations.add(weakFk);
        WeakAssociationsUtility.addWeakAssociationToTable((Table)weakAssociation.getPrimaryKeyColumn().getParent(), weakFk);
        WeakAssociationsUtility.addWeakAssociationToTable((Table)weakAssociation.getForeignKeyColumn().getParent(), weakFk);
    }

    private void findWeakAssociations(List<Table> tables) {
        LOGGER.log(Level.INFO, "Finding weak associations");
        ForeignKeys foreignKeys = new ForeignKeys(tables);
        ColumnMatchKeysMap columnMatchKeysMap = new ColumnMatchKeysMap(tables);
        TableMatchKeys tableMatchKeys = new TableMatchKeys(tables);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, (Supplier)new StringFormat("Column match keys <%s>", new Object[]{columnMatchKeysMap}));
            LOGGER.log(Level.FINER, (Supplier)new StringFormat("Column match keys <%s>", new Object[]{tableMatchKeys}));
        }
        for (Table table : tables) {
            TableCandidateKeys tableCandidateKeys = new TableCandidateKeys(table);
            LOGGER.log(Level.FINER, (Supplier)new StringFormat("Table candidate keys <%s>", new Object[]{tableCandidateKeys}));
            for (Column pkColumn : tableCandidateKeys) {
                HashSet<String> fkColumnMatchKeys = new HashSet<String>();
                if (pkColumn.isPartOfPrimaryKey()) {
                    fkColumnMatchKeys.addAll(tableMatchKeys.get(table));
                }
                if (columnMatchKeysMap.containsKey(pkColumn)) {
                    fkColumnMatchKeys.addAll(columnMatchKeysMap.get(pkColumn));
                }
                HashSet<Column> fkColumns = new HashSet<Column>();
                for (String fkColumnMatchKey : fkColumnMatchKeys) {
                    if (!columnMatchKeysMap.containsKey(fkColumnMatchKey)) continue;
                    fkColumns.addAll(columnMatchKeysMap.get(fkColumnMatchKey));
                }
                for (Column fkColumn : fkColumns) {
                    WeakAssociation weakAssociation;
                    if (pkColumn.equals(fkColumn) || !(weakAssociation = new WeakAssociation(pkColumn, fkColumn)).isValid() || foreignKeys.contains((ColumnReference)weakAssociation)) continue;
                    LOGGER.log(Level.FINE, (Supplier)new StringFormat("Found weak association <%s>", new Object[]{weakAssociation}));
                    this.addWeakAssociation(weakAssociation);
                }
            }
        }
    }
}

