/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import java.util.Objects;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.tools.executable.BaseStagedExecutable;
import schemacrawler.tools.executable.Executable;
import schemacrawler.tools.executable.ExecutableCommandProvider;
import schemacrawler.tools.integration.embeddedgraph.EmbeddedGraphExecutable;
import schemacrawler.tools.integration.graph.GraphExecutable;
import schemacrawler.tools.integration.graph.GraphOutputFormat;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.text.schema.SchemaTextDetailType;
import schemacrawler.tools.text.schema.SchemaTextExecutable;

class SchemaExecutableCommandProvider
extends ExecutableCommandProvider {
    public SchemaExecutableCommandProvider(SchemaTextDetailType schemaTextDetailType) {
        super(Objects.requireNonNull(schemaTextDetailType, "No schema text detail provided").name(), "");
    }

    @Override
    public Executable configureNewExecutable(SchemaCrawlerOptions schemaCrawlerOptions, OutputOptions outputOptions) throws SchemaCrawlerException {
        boolean isEmbeddedGraph;
        boolean isGraph;
        if (outputOptions != null) {
            String outputFormatValue = outputOptions.getOutputFormatValue();
            isGraph = GraphOutputFormat.isGraphOutputFormat(outputFormatValue);
            isEmbeddedGraph = GraphOutputFormat.htmlx.getFormat().equalsIgnoreCase(outputFormatValue);
        } else {
            isGraph = false;
            isEmbeddedGraph = false;
        }
        BaseStagedExecutable executable = isEmbeddedGraph ? new EmbeddedGraphExecutable(this.getCommand()) : (isGraph ? new GraphExecutable(this.getCommand()) : new SchemaTextExecutable(this.getCommand()));
        if (schemaCrawlerOptions != null) {
            executable.setSchemaCrawlerOptions(schemaCrawlerOptions);
        }
        if (outputOptions != null) {
            executable.setOutputOptions(outputOptions);
        }
        return executable;
    }
}

