/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.options;

import schemacrawler.tools.options.OutputFormat;

public enum TextOutputFormat implements OutputFormat
{
    text("Plain text format"),
    html("HyperText Markup Language (HTML) format"),
    csv("Comma-separated values (CSV) format"),
    tsv("Tab-separated values (TSV) format"),
    json("JavaScript Object Notation (JSON) format");

    private final String description;

    public static boolean isTextOutputFormat(String format) {
        try {
            TextOutputFormat.valueOf(format);
            return true;
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return false;
        }
    }

    public static TextOutputFormat valueOfFromString(String format) {
        TextOutputFormat outputFormat;
        try {
            outputFormat = TextOutputFormat.valueOf(format);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            outputFormat = text;
        }
        return outputFormat;
    }

    private TextOutputFormat(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getFormat() {
        return this.name();
    }

    public String toString() {
        return String.format("%s - %s", this.getFormat(), this.description);
    }
}

