/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.base;

import com.annimon.stream.function.Supplier;
import java.util.Collection;
import java.util.logging.Level;
import org.threeten.bp.temporal.TemporalAccessor;
import schemacrawler.schema.CrawlInfo;
import schemacrawler.schema.DatabaseInfo;
import schemacrawler.schema.DatabaseProperty;
import schemacrawler.schema.JdbcDriverInfo;
import schemacrawler.schema.JdbcDriverProperty;
import schemacrawler.schema.SchemaCrawlerInfo;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.text.base.BaseFormatter;
import schemacrawler.tools.text.base.BaseTextOptions;
import schemacrawler.tools.text.utility.JsonFormattingHelper;
import schemacrawler.tools.text.utility.org.json.JSONArray;
import schemacrawler.tools.text.utility.org.json.JSONException;
import schemacrawler.tools.text.utility.org.json.JSONObject;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;

public abstract class BaseJsonFormatter<O extends BaseTextOptions>
extends BaseFormatter<O> {
    protected static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger((String)BaseJsonFormatter.class.getName());
    protected final JSONObject jsonRoot = new JSONObject();

    protected BaseJsonFormatter(O options, boolean printVerboseDatabaseInfo, OutputOptions outputOptions) throws SchemaCrawlerException {
        super(options, printVerboseDatabaseInfo, outputOptions);
    }

    @Override
    public void begin() throws SchemaCrawlerException {
        if (!this.options.isNoHeader()) {
            this.formattingHelper.append("[").println();
        }
    }

    @Override
    public void end() throws SchemaCrawlerException {
        ((JsonFormattingHelper)this.formattingHelper).write(this.jsonRoot);
        if (this.options.isNoFooter()) {
            this.formattingHelper.append(",").println();
        } else {
            this.formattingHelper.append("]").println();
        }
        super.end();
    }

    @Override
    public void handle(CrawlInfo crawlInfo) throws SchemaCrawlerException {
        if (this.options.isNoInfo() || crawlInfo == null) {
            return;
        }
        try {
            JSONObject jsonSchemaCrawlerHeaderInfo = new JSONObject();
            this.jsonRoot.put("schemaCrawlerHeaderInfo", jsonSchemaCrawlerHeaderInfo);
            jsonSchemaCrawlerHeaderInfo.put("crawlTimestamp", this.formatTimestamp((TemporalAccessor)crawlInfo.getCrawlTimestamp()));
            jsonSchemaCrawlerHeaderInfo.put("title", crawlInfo.getTitle());
        }
        catch (JSONException e) {
            LOGGER.log(Level.FINER, (Supplier)new StringFormat("Error outputting SchemaCrawlerHeaderInfo: %s", new Object[]{e.getMessage()}), (Throwable)e);
        }
    }

    @Override
    public void handle(DatabaseInfo dbInfo) {
        if (!this.printVerboseDatabaseInfo || this.options.isNoInfo() || dbInfo == null) {
            return;
        }
        try {
            JSONObject jsonDbInfo = new JSONObject();
            this.jsonRoot.put("databaseInfo", jsonDbInfo);
            jsonDbInfo.put("databaseProductName", dbInfo.getProductName());
            jsonDbInfo.put("databaseProductVersion", dbInfo.getProductVersion());
            jsonDbInfo.put("databaseUserName", dbInfo.getUserName());
            if (this.printVerboseDatabaseInfo && dbInfo.getProperties().size() > 0) {
                JSONArray jsonDbProperties = new JSONArray();
                jsonDbInfo.put("databaseProperties", jsonDbProperties);
                for (DatabaseProperty property : dbInfo.getProperties()) {
                    JSONObject jsonDbProperty = new JSONObject();
                    jsonDbProperties.put(jsonDbProperty);
                    jsonDbProperty.put("name", property.getName());
                    jsonDbProperty.put("description", property.getDescription());
                    jsonDbProperty.put("value", property.getValue());
                }
            }
        }
        catch (JSONException e) {
            LOGGER.log(Level.FINER, (Supplier)new StringFormat("Error outputting DatabaseInfo: %s", new Object[]{e.getMessage()}), (Throwable)e);
        }
    }

    @Override
    public void handle(JdbcDriverInfo driverInfo) {
        if (!this.printVerboseDatabaseInfo || this.options.isNoInfo() || driverInfo == null) {
            return;
        }
        try {
            JSONObject jsonDriverInfo = new JSONObject();
            this.jsonRoot.put("jdbcDriverInfo", jsonDriverInfo);
            jsonDriverInfo.put("driverName", driverInfo.getDriverName());
            jsonDriverInfo.put("driverVersion", driverInfo.getDriverVersion());
            jsonDriverInfo.put("driverClassName", driverInfo.getDriverClassName());
            jsonDriverInfo.put("url", driverInfo.getConnectionUrl());
            jsonDriverInfo.put("isJDBCCompliant", Boolean.toString(driverInfo.isJdbcCompliant()));
            Collection jdbcDriverProperties = driverInfo.getDriverProperties();
            if (jdbcDriverProperties.size() > 0) {
                JSONArray jsonJdbcDriverProperties = new JSONArray();
                jsonDriverInfo.put("jdbcDriverProperties", jsonJdbcDriverProperties);
                for (JdbcDriverProperty driverProperty : jdbcDriverProperties) {
                    jsonJdbcDriverProperties.put(this.printJdbcDriverProperty(driverProperty));
                }
            }
        }
        catch (JSONException e) {
            LOGGER.log(Level.FINER, (Supplier)new StringFormat("Error outputting JdbcDriverInfo: %s", new Object[]{e.getMessage()}), (Throwable)e);
        }
    }

    @Override
    public void handle(SchemaCrawlerInfo schemaCrawlerInfo) {
        if (!this.printVerboseDatabaseInfo || this.options.isNoInfo() || schemaCrawlerInfo == null) {
            return;
        }
        try {
            JSONObject jsonSchemaCrawlerInfo = new JSONObject();
            this.jsonRoot.put("schemaCrawlerInfo", jsonSchemaCrawlerInfo);
            jsonSchemaCrawlerInfo.put("productName", schemaCrawlerInfo.getSchemaCrawlerProductName());
            jsonSchemaCrawlerInfo.put("productVersion", schemaCrawlerInfo.getSchemaCrawlerVersion());
        }
        catch (JSONException e) {
            LOGGER.log(Level.FINER, (Supplier)new StringFormat("Error outputting SchemaCrawlerInfo: %s", new Object[]{e.getMessage()}), (Throwable)e);
        }
    }

    @Override
    public void handleHeaderEnd() throws SchemaCrawlerException {
    }

    @Override
    public void handleHeaderStart() throws SchemaCrawlerException {
    }

    @Override
    public void handleInfoEnd() throws SchemaCrawlerException {
    }

    @Override
    public void handleInfoStart() throws SchemaCrawlerException {
    }

    private JSONObject printJdbcDriverProperty(JdbcDriverProperty driverProperty) {
        JSONObject jsonDriverProperty = new JSONObject();
        try {
            Collection choices = driverProperty.getChoices();
            if (choices != null && choices.size() > 0) {
                jsonDriverProperty.put("choices", choices);
            }
            String value = driverProperty.getValue();
            jsonDriverProperty.put("name", driverProperty.getName());
            jsonDriverProperty.put("description", driverProperty.getDescription());
            jsonDriverProperty.put("required", driverProperty.isRequired());
            jsonDriverProperty.put("value", value);
        }
        catch (JSONException e) {
            LOGGER.log(Level.FINER, (Supplier)new StringFormat("Error outputting JdbcDriverProperty: %s", new Object[]{e.getMessage()}), (Throwable)e);
        }
        return jsonDriverProperty;
    }
}

