/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.analysis.associations;

import schemacrawler.crawl.BaseColumnReference;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.Table;

public final class WeakAssociation
extends BaseColumnReference {
    private static final long serialVersionUID = -4411771492159843382L;

    WeakAssociation(Column primaryKeyColumn, Column foreignKeyColumn) {
        super(primaryKeyColumn, foreignKeyColumn);
    }

    public boolean isValid() {
        Column primaryKeyColumn = this.getPrimaryKeyColumn();
        Column foreignKeyColumn = this.getForeignKeyColumn();
        Table pkTable = (Table)primaryKeyColumn.getParent();
        Table fkTable = (Table)foreignKeyColumn.getParent();
        if ((foreignKeyColumn.isPartOfPrimaryKey() || foreignKeyColumn.isPartOfUniqueIndex()) && pkTable.compareTo((Object)fkTable) > 0) {
            return false;
        }
        ColumnDataType fkColumnType = foreignKeyColumn.getColumnDataType();
        ColumnDataType pkColumnType = primaryKeyColumn.getColumnDataType();
        boolean isValid = fkColumnType.getJavaSqlType().getName().equals(pkColumnType.getJavaSqlType().getName());
        return isValid;
    }

    public String toString() {
        return this.getPrimaryKeyColumn() + " <~~ " + this.getForeignKeyColumn();
    }
}

