/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import schemacrawler.tools.executable.CommandDescription;
import schemacrawler.tools.executable.CommandProvider;
import schemacrawler.tools.executable.commandline.PluginCommand;
import sf.util.Utility;

public abstract class BaseCommandProvider
implements CommandProvider {
    private final Collection<CommandDescription> supportedCommands;

    public BaseCommandProvider(Collection<CommandDescription> supportedCommands) {
        this.supportedCommands = Objects.requireNonNull(supportedCommands, "No supported commands provided");
    }

    public BaseCommandProvider(CommandDescription supportedCommand) {
        this(Arrays.asList(Objects.requireNonNull(supportedCommand, "No command provided")));
    }

    @Override
    public final Collection<CommandDescription> getSupportedCommands() {
        return new ArrayList<CommandDescription>(this.supportedCommands);
    }

    @Override
    public PluginCommand getCommandLineCommand() {
        return PluginCommand.empty();
    }

    protected final boolean supportsCommand(String command) {
        if (Utility.isBlank((CharSequence)command)) {
            return false;
        }
        for (CommandDescription commandDescription : this.supportedCommands) {
            if (commandDescription == null || !command.equalsIgnoreCase(commandDescription.getName())) continue;
            return true;
        }
        return false;
    }
}

