/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.operation;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.text.base.BaseJsonFormatter;
import schemacrawler.tools.text.operation.DataResultSet;
import schemacrawler.tools.text.operation.Operation;
import schemacrawler.tools.text.operation.OperationOptions;
import schemacrawler.tools.text.utility.org.json.JSONArray;
import schemacrawler.tools.text.utility.org.json.JSONException;
import schemacrawler.tools.text.utility.org.json.JSONObject;
import schemacrawler.tools.traversal.DataTraversalHandler;
import schemacrawler.utility.Query;

final class DataJsonFormatter
extends BaseJsonFormatter<OperationOptions>
implements DataTraversalHandler {
    private final JSONArray jsonDataArray;
    private final Operation operation;

    private static long handleAggregateOperationForTable(ResultSet results) throws SchemaCrawlerException {
        try {
            long aggregate = 0L;
            if (results.next()) {
                aggregate = results.getLong(1);
            }
            return aggregate;
        }
        catch (SQLException e) {
            throw new SchemaCrawlerException("Could not obtain aggregate data", (Throwable)e);
        }
    }

    private static JSONArray iterateRows(DataResultSet dataRows) throws SQLException {
        JSONArray jsonRows = new JSONArray();
        while (dataRows.next()) {
            List<Object> currentRowRaw = dataRows.row();
            ArrayList<Object> currentRow = new ArrayList<Object>();
            for (Object columnData : currentRowRaw) {
                if (columnData == null || columnData instanceof Number || columnData instanceof CharSequence || columnData instanceof Boolean || columnData instanceof Date || columnData instanceof Calendar) {
                    currentRow.add(columnData);
                    continue;
                }
                Class<?> columnDataClass = columnData.getClass();
                try {
                    if (columnDataClass.getMethod("toString", new Class[0]).getDeclaringClass() != Object.class) {
                        currentRow.add(columnData.toString());
                        continue;
                    }
                    currentRow.add(columnDataClass.getSimpleName());
                }
                catch (NoSuchMethodException | SecurityException e) {
                    currentRow.add(columnDataClass.getSimpleName());
                }
            }
            jsonRows.put(new JSONArray(currentRow));
        }
        return jsonRows;
    }

    DataJsonFormatter(Operation operation, OperationOptions options, OutputOptions outputOptions, String identifierQuoteString) throws SchemaCrawlerException {
        super(options, false, outputOptions, identifierQuoteString);
        this.operation = operation;
        this.jsonDataArray = new JSONArray();
        try {
            if (operation != null) {
                this.jsonRoot.put("description", operation.getTitle());
            }
            this.jsonRoot.put("data", this.jsonDataArray);
        }
        catch (JSONException e) {
            throw new SchemaCrawlerException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void handleData(Query query, ResultSet rows) throws SchemaCrawlerException {
        String title = query != null ? query.getName() : "";
        this.handleData(title, rows);
    }

    @Override
    public void handleData(Table table, ResultSet rows) throws SchemaCrawlerException {
        String tableName = table != null ? (((OperationOptions)this.options).isShowUnqualifiedNames() ? table.getName() : table.getFullName()) : "";
        this.handleData(tableName, rows);
    }

    private void handleData(String title, ResultSet rows) throws SchemaCrawlerException {
        if (rows == null) {
            return;
        }
        try {
            JSONObject jsonData = new JSONObject();
            jsonData.put("title", title);
            if (this.operation == Operation.count) {
                long aggregate = DataJsonFormatter.handleAggregateOperationForTable(rows);
                jsonData.put("value", aggregate);
            } else {
                try {
                    DataResultSet dataRows = new DataResultSet(rows, ((OperationOptions)this.options).isShowLobs());
                    jsonData.put("columnNames", new JSONArray(dataRows.getColumnNames()));
                    JSONArray jsonRows = DataJsonFormatter.iterateRows(dataRows);
                    jsonData.put("rows", jsonRows);
                }
                catch (SQLException e) {
                    throw new SchemaCrawlerException(e.getMessage(), (Throwable)e);
                }
            }
            this.jsonDataArray.put(jsonData);
        }
        catch (JSONException e) {
            throw new SchemaCrawlerException("Could not convert data to JSON", (Throwable)e);
        }
    }
}

