/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import schemacrawler.SchemaCrawlerLogger;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.executable.BaseSchemaCrawlerCommand;
import schemacrawler.tools.executable.CommandRegistry;
import schemacrawler.tools.executable.SchemaCrawlerCommand;
import schemacrawler.tools.options.OutputFormat;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.options.OutputOptionsBuilder;

public final class CommandChain
extends BaseSchemaCrawlerCommand {
    private static final String COMMAND = "chain";
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger((String)CommandChain.class.getName());
    private final CommandRegistry commandRegistry;
    private final List<SchemaCrawlerCommand> scCommands;

    public CommandChain(SchemaCrawlerCommand scCommand) throws SchemaCrawlerException {
        super(COMMAND);
        Objects.requireNonNull(scCommand, "No command provided, for settings");
        this.commandRegistry = CommandRegistry.getCommandRegistry();
        this.scCommands = new ArrayList<SchemaCrawlerCommand>();
        this.setSchemaCrawlerOptions(scCommand.getSchemaCrawlerOptions());
        this.setAdditionalConfiguration(scCommand.getAdditionalConfiguration());
        this.setOutputOptions(scCommand.getOutputOptions());
        this.setCatalog(scCommand.getCatalog());
        this.setConnection(scCommand.getConnection());
        this.setIdentifiers(scCommand.getIdentifiers());
    }

    public SchemaCrawlerCommand addNext(String command, OutputFormat outputFormat, Path outputFile) throws SchemaCrawlerException {
        Objects.requireNonNull(command, "No command provided");
        Objects.requireNonNull(outputFormat, "No output format provided");
        Objects.requireNonNull(outputFile, "No output file provided");
        return this.addNext(command, outputFormat.getFormat(), outputFile.normalize().toAbsolutePath().toString());
    }

    public SchemaCrawlerCommand addNext(String command, String outputFormat, String outputFileName) throws SchemaCrawlerException {
        Objects.requireNonNull(command, "No command provided");
        Objects.requireNonNull(outputFormat, "No output format provided");
        Objects.requireNonNull(outputFileName, "No output file name provided");
        Path outputFile = Paths.get(outputFileName, new String[0]);
        OutputOptions outputOptions = OutputOptionsBuilder.builder(this.getOutputOptions()).withOutputFormatValue(outputFormat).withOutputFile(outputFile).toOptions();
        return this.addNextAndConfigureForExecution(command, outputOptions);
    }

    @Override
    public void checkAvailability() throws Exception {
        this.checkAvailabilityChain();
    }

    @Override
    public void execute() throws Exception {
        if (this.scCommands.isEmpty()) {
            LOGGER.log(Level.INFO, "No command to initialize");
            return;
        }
        this.checkCatalog();
        this.initializeChain();
        this.checkAvailabilityChain();
        this.executeChain();
    }

    @Override
    public boolean usesConnection() {
        return false;
    }

    private SchemaCrawlerCommand addNextAndConfigureForExecution(String command, OutputOptions outputOptions) throws SchemaCrawlerException {
        try {
            SchemaCrawlerCommand scCommand = this.commandRegistry.configureNewCommand(command, this.schemaCrawlerOptions, this.additionalConfiguration, outputOptions);
            if (scCommand == null) {
                return null;
            }
            scCommand.setAdditionalConfiguration(this.additionalConfiguration);
            scCommand.setCatalog(this.catalog);
            scCommand.setConnection(this.connection);
            scCommand.setIdentifiers(this.identifiers);
            this.scCommands.add(scCommand);
            return scCommand;
        }
        catch (SchemaCrawlerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchemaCrawlerException(String.format("Cannot chain command, unknown command <%s>", command));
        }
    }

    private void checkAvailabilityChain() throws Exception {
        for (SchemaCrawlerCommand scCommand : this.scCommands) {
            scCommand.checkAvailability();
        }
    }

    private void executeChain() throws Exception {
        for (SchemaCrawlerCommand scCommand : this.scCommands) {
            scCommand.execute();
        }
    }

    private void initializeChain() throws Exception {
        for (SchemaCrawlerCommand scCommand : this.scCommands) {
            scCommand.initialize();
        }
    }
}

