/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Level;
import schemacrawler.SchemaCrawlerLogger;
import schemacrawler.schema.Catalog;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import schemacrawler.tools.catalogloader.CatalogLoader;
import schemacrawler.tools.catalogloader.CatalogLoaderRegistry;
import schemacrawler.tools.executable.CommandRegistry;
import schemacrawler.tools.executable.SchemaCrawlerCommand;
import schemacrawler.tools.options.Config;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.options.OutputOptionsBuilder;
import schemacrawler.utility.SchemaCrawlerUtility;
import us.fatehi.utility.Utility;
import us.fatehi.utility.string.StringFormat;

public final class SchemaCrawlerExecutable {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger((String)SchemaCrawlerExecutable.class.getName());
    private final String command;
    private Config additionalConfiguration;
    private Catalog catalog;
    private Connection connection;
    private OutputOptions outputOptions;
    private SchemaCrawlerOptions schemaCrawlerOptions;
    private SchemaRetrievalOptions schemaRetrievalOptions;

    public SchemaCrawlerExecutable(String command) {
        this.command = Utility.requireNotBlank((String)command, (String)"No command specified");
        this.schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions();
        this.outputOptions = OutputOptionsBuilder.newOutputOptions();
        this.additionalConfiguration = new Config();
    }

    public void execute() throws Exception {
        if (this.schemaRetrievalOptions == null) {
            this.schemaRetrievalOptions = SchemaCrawlerUtility.matchSchemaRetrievalOptions(this.connection);
        }
        SchemaCrawlerCommand scCommand = this.loadCommand();
        scCommand.setSchemaCrawlerOptions(this.schemaCrawlerOptions);
        scCommand.setOutputOptions(this.outputOptions);
        scCommand.setAdditionalConfiguration(this.additionalConfiguration);
        scCommand.setIdentifiers(this.schemaRetrievalOptions.getIdentifiers());
        scCommand.initialize();
        scCommand.checkAvailability();
        if (this.catalog == null) {
            this.loadCatalog();
        }
        scCommand.setCatalog(this.catalog);
        scCommand.setConnection(this.connection);
        scCommand.execute();
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public OutputOptions getOutputOptions() {
        return this.outputOptions;
    }

    public SchemaCrawlerOptions getSchemaCrawlerOptions() {
        return this.schemaCrawlerOptions;
    }

    public boolean hasConnection() {
        if (this.connection == null) {
            return false;
        }
        try {
            boolean closed = this.connection.isClosed();
            return !closed;
        }
        catch (SQLException e) {
            LOGGER.log(Level.FINE, e.getMessage(), (Throwable)e);
            return true;
        }
    }

    public void setAdditionalConfiguration(Config additionalConfiguration) {
        this.additionalConfiguration = new Config(additionalConfiguration);
    }

    public void setCatalog(Catalog catalog) {
        this.catalog = catalog;
    }

    public void setConnection(Connection connection) {
        this.connection = Objects.requireNonNull(connection, "No connection provided");
    }

    public void setOutputOptions(OutputOptions outputOptions) {
        this.outputOptions = outputOptions == null ? OutputOptionsBuilder.newOutputOptions() : outputOptions;
    }

    public void setSchemaCrawlerOptions(SchemaCrawlerOptions schemaCrawlerOptions) {
        this.schemaCrawlerOptions = schemaCrawlerOptions == null ? SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions() : schemaCrawlerOptions;
    }

    public void setSchemaRetrievalOptions(SchemaRetrievalOptions schemaRetrievalOptions) {
        this.schemaRetrievalOptions = schemaRetrievalOptions;
    }

    public String toString() {
        return this.command;
    }

    private void loadCatalog() throws Exception {
        CatalogLoaderRegistry catalogLoaderRegistry = new CatalogLoaderRegistry();
        CatalogLoader catalogLoader = catalogLoaderRegistry.lookupCatalogLoader(this.schemaRetrievalOptions.getDatabaseServerType().getDatabaseSystemIdentifier());
        LOGGER.log(Level.CONFIG, (Supplier)new StringFormat("Catalog loader: %s", new Object[]{this.getClass().getName()}));
        catalogLoader.setAdditionalConfiguration(this.additionalConfiguration);
        catalogLoader.setConnection(this.connection);
        catalogLoader.setSchemaRetrievalOptions(this.schemaRetrievalOptions);
        catalogLoader.setSchemaCrawlerOptions(this.schemaCrawlerOptions);
        this.catalog = catalogLoader.loadCatalog();
        Objects.requireNonNull(this.catalog, "Catalog could not be retrieved");
    }

    private SchemaCrawlerCommand loadCommand() throws SchemaCrawlerException {
        CommandRegistry commandRegistry = CommandRegistry.getCommandRegistry();
        SchemaCrawlerCommand scCommand = commandRegistry.configureNewCommand(this.command, this.schemaCrawlerOptions, this.additionalConfiguration, this.outputOptions);
        if (scCommand == null) {
            throw new SchemaCrawlerException("Could not configure command, " + this.command);
        }
        return scCommand;
    }
}

