/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable.commandline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Supplier;
import schemacrawler.tools.executable.commandline.PluginCommandOption;
import schemacrawler.tools.executable.commandline.PluginCommandType;
import us.fatehi.utility.Utility;

public class PluginCommand
implements Iterable<PluginCommandOption> {
    private final PluginCommandType type;
    private final String helpDescription;
    private final String helpHeader;
    private final String name;
    private final Supplier<String> helpFooter;
    private final Collection<PluginCommandOption> options;

    public static PluginCommand empty() {
        return new PluginCommand(PluginCommandType.command, null, null, null, null, null);
    }

    public static PluginCommand newDatabasePluginCommand(String name, String helpHeader) {
        return new PluginCommand(PluginCommandType.server, name, helpHeader, null, null, null);
    }

    public static PluginCommand newPluginCommand(String name, String helpHeader) {
        return new PluginCommand(PluginCommandType.command, name, helpHeader, null, null, null);
    }

    public static PluginCommand newPluginCommand(String name, String helpHeader, String helpDescription) {
        return new PluginCommand(PluginCommandType.command, name, helpHeader, helpDescription, null, null);
    }

    public static PluginCommand newPluginCommand(String name, String helpHeader, String helpDescription, Supplier<String> helpFooter) {
        return new PluginCommand(PluginCommandType.command, name, helpHeader, helpDescription, helpFooter, null);
    }

    private PluginCommand(PluginCommandType type, String name, String helpHeader, String helpDescription, Supplier<String> helpFooter, Collection<PluginCommandOption> options) {
        this.type = Objects.requireNonNull(type, "No plugin command type provided");
        this.options = options == null ? new ArrayList<PluginCommandOption>() : new HashSet<PluginCommandOption>(options);
        if (Utility.isBlank((CharSequence)name) && !this.options.isEmpty()) {
            throw new IllegalArgumentException("No command name provided");
        }
        this.name = name;
        this.helpHeader = Utility.isBlank((CharSequence)helpHeader) ? null : helpHeader;
        this.helpDescription = Utility.isBlank((CharSequence)helpDescription) ? null : helpDescription;
        this.helpFooter = helpFooter;
    }

    public PluginCommand addOption(String name, String helpText, Class<?> valueClass) {
        PluginCommandOption option = new PluginCommandOption(name, helpText, valueClass);
        if (option != null) {
            this.options.add(option);
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PluginCommand)) {
            return false;
        }
        PluginCommand that = (PluginCommand)o;
        return Objects.equals(this.name, that.name);
    }

    public String getHelpDescription() {
        return this.helpDescription;
    }

    public Supplier<String> getHelpFooter() {
        return this.helpFooter;
    }

    public String getHelpHeader() {
        return this.helpHeader;
    }

    public String getName() {
        return this.type.toPluginCommandName(this.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public boolean hasHelpFooter() {
        return this.helpFooter != null;
    }

    public boolean isEmpty() {
        return Utility.isBlank((CharSequence)this.name) && this.options.isEmpty();
    }

    @Override
    public Iterator<PluginCommandOption> iterator() {
        return this.options.iterator();
    }

    public String toString() {
        return new StringJoiner(", ", PluginCommand.class.getSimpleName() + "[", "]").add("name='" + this.name + "'").add("options=" + this.options).toString();
    }
}

