/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.operation;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import schemacrawler.analysis.counts.TableRowCountsUtility;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.text.base.BaseTabularFormatter;
import schemacrawler.tools.text.operation.Operation;
import schemacrawler.tools.text.operation.OperationOptions;
import schemacrawler.tools.text.utility.TextFormattingHelper;
import schemacrawler.tools.traversal.DataTraversalHandler;
import us.fatehi.utility.Color;
import us.fatehi.utility.html.Alignment;

final class DataTextFormatter
extends BaseTabularFormatter<OperationOptions>
implements DataTraversalHandler {
    private final Operation operation;
    private int dataBlockCount;

    private static String getMessage(double aggregate) {
        Number number = Math.abs(aggregate - (double)((int)aggregate)) < 1.0E-10 ? (Number)((int)aggregate) : (Number)aggregate;
        String message = TableRowCountsUtility.getRowCountMessage((Number)number);
        return message;
    }

    DataTextFormatter(Operation operation, OperationOptions options, OutputOptions outputOptions, String identifierQuoteString) throws SchemaCrawlerException {
        super(options, false, outputOptions, identifierQuoteString);
        this.operation = operation;
    }

    @Override
    public void end() throws SchemaCrawlerException {
        if (this.operation == Operation.count) {
            this.formattingHelper.writeObjectEnd();
        }
        super.end();
    }

    @Override
    public void handleData(Query query, ResultSet rows) throws SchemaCrawlerException {
        String title = query != null ? query.getName() : "";
        this.handleData(title, rows);
    }

    @Override
    public void handleData(Table table, ResultSet rows) throws SchemaCrawlerException {
        String tableName = table != null ? (((OperationOptions)this.options).isShowUnqualifiedNames() ? this.identifiers.quoteName((NamedObject)table) : this.identifiers.quoteFullName((DatabaseObject)table)) : "";
        this.handleData(tableName, rows);
    }

    private void handleAggregateOperationForTable(String title, ResultSet results) throws SchemaCrawlerException {
        long aggregate = 0L;
        try {
            if (results.next()) {
                aggregate = results.getLong(1);
            }
        }
        catch (SQLException e) {
            throw new SchemaCrawlerException("Could not obtain aggregate data", (Throwable)e);
        }
        String message = DataTextFormatter.getMessage(aggregate);
        this.formattingHelper.writeNameValueRow(title, message, Alignment.right);
    }

    private void handleData(String title, ResultSet rows) throws SchemaCrawlerException {
        if (rows == null) {
            return;
        }
        if (this.dataBlockCount == 0) {
            this.printHeader();
        }
        if (this.operation == Operation.count) {
            this.handleAggregateOperationForTable(title, rows);
        } else {
            this.formattingHelper.println();
            this.formattingHelper.println();
            this.formattingHelper.writeObjectStart();
            this.formattingHelper.writeObjectNameRow("", title, "", Color.white);
            try {
                MetadataResultSet dataRows = new MetadataResultSet(rows);
                dataRows.setShowLobs(((OperationOptions)this.options).isShowLobs());
                this.formattingHelper.writeRowHeader(dataRows.getColumnNames());
                this.iterateRows(dataRows);
            }
            catch (SQLException e) {
                throw new SchemaCrawlerException(e.getMessage(), (Throwable)e);
            }
            this.formattingHelper.writeObjectEnd();
        }
        ++this.dataBlockCount;
    }

    private void iterateRows(MetadataResultSet dataRows) throws SQLException {
        while (dataRows.next()) {
            List currentRow = dataRows.row();
            Object[] columnData = currentRow.toArray(new Object[currentRow.size()]);
            this.formattingHelper.writeRow(columnData);
        }
    }

    private void printHeader() {
        if (this.operation == null) {
            this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "Query");
            return;
        }
        this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.subTitle, this.operation.getTitle());
        if (this.operation == Operation.count) {
            this.formattingHelper.writeObjectStart();
            this.formattingHelper.writeObjectNameRow("", this.operation.getTitle(), "", Color.white);
        }
    }
}

