/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.schema;

import java.util.Comparator;
import java.util.Objects;
import schemacrawler.schema.NamedObject;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.executable.BaseSchemaCrawlerCommand;
import schemacrawler.tools.options.TextOutputFormat;
import schemacrawler.tools.text.base.BaseFormatter;
import schemacrawler.tools.text.schema.SchemaListFormatter;
import schemacrawler.tools.text.schema.SchemaTextDetailType;
import schemacrawler.tools.text.schema.SchemaTextFormatter;
import schemacrawler.tools.text.schema.SchemaTextOptions;
import schemacrawler.tools.text.schema.SchemaTextOptionsBuilder;
import schemacrawler.tools.traversal.SchemaTraversalHandler;
import schemacrawler.tools.traversal.SchemaTraverser;
import schemacrawler.utility.NamedObjectSort;

public final class SchemaTextRenderer
extends BaseSchemaCrawlerCommand {
    private SchemaTextOptions schemaTextOptions;

    public SchemaTextRenderer(String command) {
        super(command);
    }

    @Override
    public void checkAvailability() throws Exception {
    }

    @Override
    public void execute() throws Exception {
        this.checkCatalog();
        SchemaTraversalHandler formatter = this.getSchemaTraversalHandler();
        SchemaTraverser traverser = new SchemaTraverser();
        traverser.setCatalog(this.catalog);
        traverser.setHandler(formatter);
        traverser.setTablesComparator((Comparator<NamedObject>)NamedObjectSort.getNamedObjectSort((boolean)this.schemaTextOptions.isAlphabeticalSortForTables()));
        traverser.setRoutinesComparator((Comparator<NamedObject>)NamedObjectSort.getNamedObjectSort((boolean)this.schemaTextOptions.isAlphabeticalSortForRoutines()));
        traverser.traverse();
    }

    public SchemaTextOptions getSchemaTextOptions() {
        return this.schemaTextOptions;
    }

    @Override
    public void initialize() throws Exception {
        super.initialize();
        this.loadSchemaTextOptions();
    }

    public void setSchemaTextOptions(SchemaTextOptions schemaTextOptions) {
        this.schemaTextOptions = Objects.requireNonNull(schemaTextOptions, "No schema text options provided");
    }

    @Override
    public boolean usesConnection() {
        return false;
    }

    private SchemaTextDetailType getSchemaTextDetailType() {
        SchemaTextDetailType schemaTextDetailType;
        try {
            schemaTextDetailType = SchemaTextDetailType.valueOf(this.command);
        }
        catch (IllegalArgumentException e) {
            schemaTextDetailType = SchemaTextDetailType.schema;
        }
        return schemaTextDetailType;
    }

    private SchemaTraversalHandler getSchemaTraversalHandler() throws SchemaCrawlerException {
        SchemaTextDetailType schemaTextDetailType = this.getSchemaTextDetailType();
        String identifierQuoteString = this.identifiers.getIdentifierQuoteString();
        TextOutputFormat outputFormat = TextOutputFormat.fromFormat(this.outputOptions.getOutputFormatValue());
        BaseFormatter formatter = schemaTextDetailType == SchemaTextDetailType.list ? new SchemaListFormatter(schemaTextDetailType, this.schemaTextOptions, this.outputOptions, identifierQuoteString) : new SchemaTextFormatter(schemaTextDetailType, this.schemaTextOptions, this.outputOptions, identifierQuoteString);
        return formatter;
    }

    private void loadSchemaTextOptions() {
        if (this.schemaTextOptions == null) {
            this.schemaTextOptions = ((SchemaTextOptionsBuilder)SchemaTextOptionsBuilder.builder().fromConfig(this.additionalConfiguration)).toOptions();
        }
    }
}

