/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.utility;

import java.io.PrintWriter;
import schemacrawler.tools.options.TextOutputFormat;
import schemacrawler.tools.text.utility.BaseTextFormattingHelper;
import schemacrawler.tools.text.utility.TextFormattingHelper;
import us.fatehi.utility.Color;
import us.fatehi.utility.IOUtility;
import us.fatehi.utility.Utility;
import us.fatehi.utility.html.Tag;
import us.fatehi.utility.html.TagBuilder;
import us.fatehi.utility.html.TagOutputFormat;

public final class HtmlFormattingHelper
extends BaseTextFormattingHelper {
    private static final String HTML_HEADER = HtmlFormattingHelper.htmlHeader();
    private static final String HTML_FOOTER = "</body>" + System.lineSeparator() + "</html>";

    private static String htmlHeader() {
        StringBuilder styleSheet = new StringBuilder(4096);
        styleSheet.append(System.lineSeparator()).append(IOUtility.readResourceFully((String)"/sc.css")).append(System.lineSeparator()).append(IOUtility.readResourceFully((String)"/sc_output.css")).append(System.lineSeparator());
        String htmlHeaderTemplate = IOUtility.readResourceFully((String)"/html.header.txt");
        String htmlHeader = String.format(htmlHeaderTemplate, styleSheet);
        return htmlHeader;
    }

    public HtmlFormattingHelper(PrintWriter out, TextOutputFormat outputFormat) {
        super(out, outputFormat);
    }

    @Override
    public String createLeftArrow() {
        return "\u2190";
    }

    @Override
    public String createRightArrow() {
        return "\u2192";
    }

    @Override
    public String createWeakLeftArrow() {
        return "\u21dc";
    }

    @Override
    public String createWeakRightArrow() {
        return "\u21dd";
    }

    @Override
    public void writeDocumentEnd() {
        this.out.println(HTML_FOOTER);
    }

    @Override
    public void writeDocumentStart() {
        this.out.println(HTML_HEADER);
    }

    @Override
    public void writeHeader(TextFormattingHelper.DocumentHeaderType type, String header) {
        if (!Utility.isBlank((CharSequence)header) && type != null) {
            this.out.println(String.format("%s%n<%s>%s</%s>%n", type.getPrefix(), type.getHeaderTag(), header, type.getHeaderTag()));
        }
    }

    @Override
    public void writeObjectEnd() {
        this.out.append("</table>").println();
        this.out.println("<p>&#160;</p>");
        this.out.println();
    }

    @Override
    public void writeObjectNameRow(String id, String name, String description, Color backgroundColor) {
        Tag span;
        Tag caption = TagBuilder.caption().withStyle(String.format("background-color: %s;", backgroundColor)).make();
        if (!Utility.isBlank((CharSequence)name)) {
            span = TagBuilder.span().withEscapedText(name).withStyleClass("caption_name").make();
            if (!Utility.isBlank((CharSequence)id)) {
                span.addAttribute("id", id);
            }
            caption.addInnerTag(span);
        }
        if (!Utility.isBlank((CharSequence)description)) {
            span = TagBuilder.span().withEscapedText(description).withStyleClass("caption_description").make();
            caption.addInnerTag(span);
        }
        StringBuilder buffer = new StringBuilder(1024);
        buffer.append(caption.render(TagOutputFormat.html)).append(System.lineSeparator());
        this.out.println(buffer.toString());
    }

    @Override
    public void writeObjectStart() {
        this.out.println("<table>");
    }
}

