/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test;

import com.github.stefanbirkner.systemlambda.SystemLambda;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import schemacrawler.schemacrawler.exceptions.InternalRuntimeException;
import schemacrawler.test.utility.TestCatalogLoader;
import schemacrawler.tools.catalogloader.CatalogLoaderRegistry;
import schemacrawler.tools.catalogloader.ChainedCatalogLoader;
import schemacrawler.tools.executable.CommandDescription;
import schemacrawler.tools.executable.commandline.PluginCommand;

public class CatalogLoaderRegistryTest {
    @Test
    public void commandLineCommands() throws Exception {
        Collection commandLineCommands = new CatalogLoaderRegistry().getCommandLineCommands();
        MatcherAssert.assertThat((Object)commandLineCommands, (Matcher)Matchers.hasSize((int)2));
        List names = commandLineCommands.stream().map(PluginCommand::getName).collect(Collectors.toList());
        MatcherAssert.assertThat(names, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"loader:testloader", null}));
        SystemLambda.restoreSystemProperties(() -> {
            System.setProperty(TestCatalogLoader.class.getName() + ".force-instantiation-failure", "throw");
            Assertions.assertThrows(InternalRuntimeException.class, () -> new CatalogLoaderRegistry().getCommandLineCommands());
        });
    }

    @Test
    public void helpCommands() throws Exception {
        Collection helpCommands = new CatalogLoaderRegistry().getHelpCommands();
        MatcherAssert.assertThat((String)String.valueOf(helpCommands), (Object)helpCommands, (Matcher)Matchers.hasSize((int)2));
        List names = helpCommands.stream().map(PluginCommand::getName).collect(Collectors.toList());
        MatcherAssert.assertThat(names, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"loader:testloader", null}));
        SystemLambda.restoreSystemProperties(() -> {
            System.setProperty(TestCatalogLoader.class.getName() + ".force-instantiation-failure", "throw");
            Assertions.assertThrows(InternalRuntimeException.class, () -> new CatalogLoaderRegistry().getHelpCommands());
        });
    }

    @Test
    public void loadCatalogLoaders() {
        ChainedCatalogLoader chainedCatalogLoaders = new CatalogLoaderRegistry().newChainedCatalogLoader();
        ArrayList catalogLoaders = new ArrayList();
        chainedCatalogLoaders.forEach(catalogLoaders::add);
        MatcherAssert.assertThat(catalogLoaders, (Matcher)Matchers.hasSize((int)2));
    }

    @Test
    public void supportedCatalogLoaders() throws Exception {
        Collection supportedCatalogLoaders = new CatalogLoaderRegistry().getSupportedCatalogLoaders();
        MatcherAssert.assertThat((Object)supportedCatalogLoaders, (Matcher)Matchers.hasSize((int)2));
        List names = supportedCatalogLoaders.stream().map(CommandDescription::getName).collect(Collectors.toList());
        MatcherAssert.assertThat(names, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"testloader", "schemacrawlerloader"}));
        SystemLambda.restoreSystemProperties(() -> {
            System.setProperty(TestCatalogLoader.class.getName() + ".force-instantiation-failure", "throw");
            Assertions.assertThrows(InternalRuntimeException.class, () -> new CatalogLoaderRegistry().getSupportedCatalogLoaders());
        });
    }
}

