/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test;

import java.util.Collection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import schemacrawler.schemacrawler.exceptions.ConfigurationException;
import schemacrawler.schemacrawler.exceptions.ExecutionRuntimeException;
import schemacrawler.schemacrawler.exceptions.InternalRuntimeException;
import schemacrawler.test.utility.testcommand.TestCommandProvider;
import schemacrawler.tools.executable.CommandRegistry;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.options.OutputOptionsBuilder;

public class CommandRegistryTest {
    @Test
    public void configureNewCommand() {
        CommandRegistry commandRegistry = CommandRegistry.getCommandRegistry();
        Assertions.assertThrows(ExecutionRuntimeException.class, () -> commandRegistry.configureNewCommand("bad-command", null, null, null));
        Assertions.assertThrows(InternalRuntimeException.class, () -> commandRegistry.configureNewCommand("test-command", null, null, null));
        OutputOptions outputOptions = OutputOptionsBuilder.builder().withOutputFormatValue("unknown-output-format").toOptions();
        Assertions.assertThrows(ConfigurationException.class, () -> commandRegistry.configureNewCommand("test-command", null, null, outputOptions));
    }

    @Test
    public void getCommandLineCommands() {
        TestCommandProvider testCommandProvider = new TestCommandProvider();
        CommandRegistry commandRegistry = CommandRegistry.getCommandRegistry();
        Collection commandLineCommands = commandRegistry.getCommandLineCommands();
        MatcherAssert.assertThat((Object)commandLineCommands, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)commandLineCommands, (Matcher)Matchers.hasItem((Object)testCommandProvider.getCommandLineCommand()));
    }

    @Test
    public void getHelpCommands() {
        TestCommandProvider testCommandProvider = new TestCommandProvider();
        CommandRegistry commandRegistry = CommandRegistry.getCommandRegistry();
        Collection commandLineCommands = commandRegistry.getHelpCommands();
        MatcherAssert.assertThat((Object)commandLineCommands, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)commandLineCommands, (Matcher)Matchers.hasItem((Object)testCommandProvider.getHelpCommand()));
    }

    @Test
    public void getSupportedCommands() {
        TestCommandProvider testCommandProvider = new TestCommandProvider();
        CommandRegistry commandRegistry = CommandRegistry.getCommandRegistry();
        Collection commandLineCommands = commandRegistry.getSupportedCommands();
        MatcherAssert.assertThat((Object)commandLineCommands, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)commandLineCommands, (Matcher)CoreMatchers.is((Object)testCommandProvider.getSupportedCommands()));
    }
}

