/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import schemacrawler.schemacrawler.DatabaseServerType;
import schemacrawler.tools.databaseconnector.DatabaseConnector;
import schemacrawler.tools.databaseconnector.DatabaseConnectorRegistry;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class DatabaseConnectorRegistryTest {
    private DatabaseConnectorRegistry databaseConnectorRegistry;

    @Test
    public void databaseConnectorRegistry() {
        List databaseServerTypes = StreamSupport.stream(this.databaseConnectorRegistry.spliterator(), false).collect(Collectors.toList());
        MatcherAssert.assertThat(databaseServerTypes, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)this.databaseConnectorRegistry.hasDatabaseSystemIdentifier("test-db"), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.databaseConnectorRegistry.getHelpCommands(), (Matcher)Matchers.hasSize((int)1));
        DatabaseConnector testDbConnector = this.databaseConnectorRegistry.findDatabaseConnectorFromDatabaseSystemIdentifier("test-db");
        MatcherAssert.assertThat((Object)testDbConnector, (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)testDbConnector.getDatabaseServerType().getDatabaseSystemIdentifier(), (Matcher)CoreMatchers.is((Object)"test-db"));
        DatabaseConnector unknownConnector = this.databaseConnectorRegistry.findDatabaseConnectorFromDatabaseSystemIdentifier("newdb");
        MatcherAssert.assertThat((Object)unknownConnector, (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)unknownConnector.getDatabaseServerType().getDatabaseSystemIdentifier(), (Matcher)CoreMatchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void findDatabaseConnectorFromUrl() {
        DatabaseServerType databaseServerType = this.databaseConnectorRegistry.findDatabaseConnectorFromUrl("jdbc:test-db:something").getDatabaseServerType();
        MatcherAssert.assertThat((Object)databaseServerType.getDatabaseSystemIdentifier(), (Matcher)CoreMatchers.is((Object)"test-db"));
        databaseServerType = this.databaseConnectorRegistry.findDatabaseConnectorFromUrl("jdbc:other-db:something").getDatabaseServerType();
        MatcherAssert.assertThat((Object)databaseServerType, (Matcher)CoreMatchers.is((Object)DatabaseServerType.UNKNOWN));
        databaseServerType = this.databaseConnectorRegistry.findDatabaseConnectorFromUrl(null).getDatabaseServerType();
        MatcherAssert.assertThat((Object)databaseServerType, (Matcher)CoreMatchers.is((Object)DatabaseServerType.UNKNOWN));
    }

    @BeforeAll
    public void initDatabaseConnectorRegistry() {
        this.databaseConnectorRegistry = DatabaseConnectorRegistry.getDatabaseConnectorRegistry();
    }
}

