/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.ResultsColumns;
import schemacrawler.schema.Schema;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.schemacrawler.exceptions.DatabaseAccessException;
import schemacrawler.schemacrawler.exceptions.InternalRuntimeException;
import schemacrawler.test.utility.CaptureLogs;
import schemacrawler.test.utility.CapturedLogs;
import schemacrawler.test.utility.WithSystemProperty;
import schemacrawler.test.utility.WithTestDatabase;
import schemacrawler.tools.utility.SchemaCrawlerUtility;
import us.fatehi.utility.datasource.DatabaseConnectionSource;
import us.fatehi.utility.datasource.DatabaseConnectionSourceUtility;

@WithTestDatabase
public class SchemaCrawlerUtilityTest {
    @Test
    @WithSystemProperty(key="SC_WITHOUT_DATABASE_PLUGIN", value="hsqldb")
    @CaptureLogs
    public void getCatalog(DatabaseConnectionSource dataSource, CapturedLogs logs) throws Exception {
        Catalog catalog = SchemaCrawlerUtility.getCatalog((DatabaseConnectionSource)dataSource, (SchemaCrawlerOptions)SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions());
        MatcherAssert.assertThat((Object)catalog, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        Schema[] schemas = catalog.getSchemas().toArray(new Schema[0]);
        MatcherAssert.assertThat((String)"Schema count does not match", (Object)schemas, (Matcher)Matchers.arrayWithSize((int)6));
    }

    @Test
    public void getCatalogClosedConnection(Connection connection) throws Exception {
        DatabaseConnectionSource dataSource = DatabaseConnectionSourceUtility.newTestDatabaseConnectionSource((Connection)connection);
        connection.close();
        Assertions.assertThrows(DatabaseAccessException.class, () -> SchemaCrawlerUtility.getCatalog((DatabaseConnectionSource)dataSource, (SchemaCrawlerOptions)SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions()));
    }

    @Test
    public void getCatalogMissingPlugin(DatabaseConnectionSource dataSource) throws Exception {
        InternalRuntimeException exception = (InternalRuntimeException)Assertions.assertThrows(InternalRuntimeException.class, () -> SchemaCrawlerUtility.getCatalog((DatabaseConnectionSource)dataSource, (SchemaCrawlerOptions)SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions()));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.containsString((String)"hsqldb"));
    }

    @Test
    public void getResultsColumns() throws Exception {
        ResultSet results = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)results.getMetaData()).thenThrow(SQLException.class);
        Assertions.assertThrows(DatabaseAccessException.class, () -> SchemaCrawlerUtility.getResultsColumns((ResultSet)results));
    }

    @Test
    public void getResultsColumns(DatabaseConnectionSource dataSource) throws Exception {
        try (Connection connection = (Connection)dataSource.get();
             ResultSet results = connection.getMetaData().getCatalogs();){
            ResultsColumns resultsColumns = SchemaCrawlerUtility.getResultsColumns((ResultSet)results);
            MatcherAssert.assertThat((Object)resultsColumns, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
            String columnsListAsString = resultsColumns.getColumnsListAsString();
            MatcherAssert.assertThat((Object)columnsListAsString, (Matcher)Matchers.is((Object)"PUBLIC.INFORMATION_SCHEMA.INFORMATION_SCHEMA_CATALOG_NAME.CATALOG_NAME"));
        }
    }

    @Test
    public void getResultsColumnsClosedResults(DatabaseConnectionSource dataSource) throws Exception {
        try (Connection connection = (Connection)dataSource.get();){
            ResultSet results = connection.getMetaData().getCatalogs();
            results.close();
            Assertions.assertThrows(DatabaseAccessException.class, () -> SchemaCrawlerUtility.getResultsColumns((ResultSet)results));
        }
    }
}

