/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test.utility.testcommand;

import schemacrawler.test.utility.testcommand.TestCommand;
import schemacrawler.test.utility.testcommand.TestOptions;
import schemacrawler.tools.executable.BaseCommandProvider;
import schemacrawler.tools.executable.CommandDescription;
import schemacrawler.tools.executable.commandline.PluginCommand;
import schemacrawler.tools.options.Config;
import schemacrawler.tools.options.OutputOptions;

public class TestCommandProvider
extends BaseCommandProvider {
    public static final String DESCRIPTION_HEADER = "Test command which is not deployed with the release";

    public TestCommandProvider() {
        super(new CommandDescription("test-command", DESCRIPTION_HEADER));
    }

    public PluginCommand getCommandLineCommand() {
        PluginCommand pluginCommand = PluginCommand.newPluginCommand((String)"test-command", (String)"** Test command which is not deployed with the release");
        pluginCommand.addOption("test-command-parameter", String.class, new String[]{"Parameter for test command"});
        return pluginCommand;
    }

    public TestCommand newSchemaCrawlerCommand(String command, Config config) {
        String testCommandParameter = config.getStringValue("test-command-parameter", "");
        boolean throwRuntimeException = config.getBooleanValue("throw-runtime-exception");
        boolean returnNull = config.getBooleanValue("return-null");
        boolean usesConnection = config.getBooleanValue("uses-connection", true);
        if (returnNull) {
            return null;
        }
        if (throwRuntimeException) {
            throw new RuntimeException("Request throw during command initialization");
        }
        TestOptions commandOptions = new TestOptions(usesConnection, testCommandParameter);
        TestCommand testCommand = new TestCommand();
        testCommand.setCommandOptions(commandOptions);
        return testCommand;
    }

    public boolean supportsOutputFormat(String command, OutputOptions outputOptions) {
        if (outputOptions == null) {
            return true;
        }
        String outputFormatValue = outputOptions.getOutputFormatValue();
        return outputFormatValue.equals("text") || outputFormatValue.equals("txt");
    }
}

