/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test;

import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import schemacrawler.test.utility.testcommand.TestCommandProvider;
import schemacrawler.tools.executable.BaseCommandProvider;
import schemacrawler.tools.executable.CommandDescription;
import schemacrawler.tools.executable.CommandProvider;
import schemacrawler.tools.executable.CommandRegistry;
import schemacrawler.tools.executable.SchemaCrawlerCommand;
import schemacrawler.tools.options.Config;
import schemacrawler.tools.options.OutputOptions;

public class CommandProviderSortTest {
    private final TestCommandProvider testCommandProvider = new TestCommandProvider();
    private final CommandProvider fallbackCommandProvider = new OperationCommandProvider();
    private final CommandProvider otherCommandProvider = new BaseCommandProvider(Arrays.asList(new CommandDescription("OtherCommandProvider", "OtherCommandProvider"))){

        public SchemaCrawlerCommand<?> newSchemaCrawlerCommand(String command, Config config) {
            return null;
        }

        public boolean supportsOutputFormat(String command, OutputOptions outputOptions) {
            return false;
        }
    };

    @Test
    public void sort() {
        MatcherAssert.assertThat((Object)CommandRegistry.commandComparator.compare(this.testCommandProvider, this.testCommandProvider), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)CommandRegistry.commandComparator.compare(this.testCommandProvider, this.otherCommandProvider), (Matcher)CoreMatchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        MatcherAssert.assertThat((Object)CommandRegistry.commandComparator.compare(this.otherCommandProvider, this.testCommandProvider), (Matcher)CoreMatchers.is((Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0))));
    }

    @Test
    public void sortForFallBack() {
        MatcherAssert.assertThat((Object)CommandRegistry.commandComparator.compare(this.fallbackCommandProvider, this.fallbackCommandProvider), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)CommandRegistry.commandComparator.compare(this.testCommandProvider, this.fallbackCommandProvider), (Matcher)CoreMatchers.is((Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0))));
        MatcherAssert.assertThat((Object)CommandRegistry.commandComparator.compare(this.fallbackCommandProvider, this.testCommandProvider), (Matcher)CoreMatchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
    }

    @Test
    public void sortNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> CommandRegistry.commandComparator.compare(null, null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> CommandRegistry.commandComparator.compare(this.testCommandProvider, null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> CommandRegistry.commandComparator.compare(null, this.fallbackCommandProvider));
    }

    private final class OperationCommandProvider
    extends BaseCommandProvider {
        private OperationCommandProvider() {
            super(Arrays.asList(new CommandDescription("OperationCommandProvider", "OperationCommandProvider")));
        }

        public SchemaCrawlerCommand<?> newSchemaCrawlerCommand(String command, Config config) {
            return null;
        }

        public boolean supportsOutputFormat(String command, OutputOptions outputOptions) {
            return false;
        }
    }
}

