/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test;

import com.github.npathai.hamcrestopt.OptionalMatchers;
import java.time.DayOfWeek;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import schemacrawler.inclusionrule.RegularExpressionRule;
import schemacrawler.tools.options.Config;

public class ConfigTest {
    @Test
    public void emptyConfig() {
        Config config = new Config();
        this.assertEmptyConfig(config);
    }

    @Test
    public void emptyConfig1() {
        Config config = new Config(new HashMap());
        this.assertEmptyConfig(config);
    }

    @Test
    public void emptyConfig1a() {
        Config config = new Config((Config)null);
        this.assertEmptyConfig(config);
    }

    @Test
    public void emptyConfig2() {
        Config config = new Config(new Config());
        this.assertEmptyConfig(config);
    }

    @Test
    public void emptyConfig2b() {
        Config config = new Config((Map)null);
        this.assertEmptyConfig(config);
    }

    @Test
    public void getBooleanValue() {
        Config config = new Config();
        MatcherAssert.assertThat((Object)config.getBooleanValue("key"), (Matcher)CoreMatchers.is((Object)false));
        config.put("key", (Object)false);
        MatcherAssert.assertThat((Object)config.getBooleanValue("key"), (Matcher)CoreMatchers.is((Object)false));
        config.put("key", (Object)true);
        MatcherAssert.assertThat((Object)config.getBooleanValue("key"), (Matcher)CoreMatchers.is((Object)true));
        config.put("key", (Object)"blah");
        MatcherAssert.assertThat((Object)config.getBooleanValue("key"), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void getEnumValue() {
        Config config = new Config();
        MatcherAssert.assertThat((Object)config.getEnumValue("key", (Enum)DayOfWeek.MONDAY), (Matcher)CoreMatchers.is((Object)DayOfWeek.MONDAY));
        config.put("key", (Object)DayOfWeek.FRIDAY.name());
        MatcherAssert.assertThat((Object)config.getEnumValue("key", (Enum)DayOfWeek.MONDAY), (Matcher)CoreMatchers.is((Object)DayOfWeek.FRIDAY));
        config.put("key", (Object)"blah");
        MatcherAssert.assertThat((Object)config.getEnumValue("key", (Enum)DayOfWeek.MONDAY), (Matcher)CoreMatchers.is((Object)DayOfWeek.MONDAY));
    }

    @Test
    public void getIntegerValue() {
        Config config = new Config();
        MatcherAssert.assertThat((Object)config.getIntegerValue("key", -1), (Matcher)CoreMatchers.is((Object)-1));
        config.put("key", (Object)"1");
        MatcherAssert.assertThat((Object)config.getIntegerValue("key", -1), (Matcher)CoreMatchers.is((Object)1));
        config.put("key", (Object)"1.1");
        MatcherAssert.assertThat((Object)config.getIntegerValue("key", -1), (Matcher)CoreMatchers.is((Object)-1));
        config.put("key", (Object)"blah");
        MatcherAssert.assertThat((Object)config.getIntegerValue("key", -1), (Matcher)CoreMatchers.is((Object)-1));
    }

    @Test
    public void getOptionalInclusionRule() {
        Config config = new Config();
        MatcherAssert.assertThat((Object)config.getOptionalInclusionRule("in", "ex"), (Matcher)CoreMatchers.is((Matcher)OptionalMatchers.isEmpty()));
        config.put("in", (Object)".*");
        config.put("ex", (Object)"exc");
        MatcherAssert.assertThat((Object)config.getOptionalInclusionRule("in", "ex"), (Matcher)CoreMatchers.is((Matcher)OptionalMatchers.isPresentAndIs((Object)new RegularExpressionRule(".*", "exc"))));
        config.put("in", (Object)".*");
        config.put("ex", null);
        MatcherAssert.assertThat((Object)config.getOptionalInclusionRule("in", "ex"), (Matcher)CoreMatchers.is((Matcher)OptionalMatchers.isPresentAndIs((Object)new RegularExpressionRule(".*", null))));
        config.put("in", null);
        config.put("ex", (Object)"exc");
        MatcherAssert.assertThat((Object)config.getOptionalInclusionRule("in", "ex"), (Matcher)CoreMatchers.is((Matcher)OptionalMatchers.isPresentAndIs((Object)new RegularExpressionRule(null, "exc"))));
    }

    @Test
    public void notEmptyConfig() {
        Config config = new Config();
        config.put("key", (Object)"value");
        this.assertNotEmptyConfig(config);
    }

    @Test
    public void notEmptyConfig1() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", "value");
        Config config = new Config(map);
        this.assertNotEmptyConfig(config);
    }

    @Test
    public void notEmptyConfig2() {
        Config map = new Config();
        map.put("key", (Object)"value");
        Config config = new Config(map);
        this.assertNotEmptyConfig(config);
    }

    @Test
    public void putEnumValue() {
        Config config = new Config();
        MatcherAssert.assertThat((Object)config.containsKey("key"), (Matcher)CoreMatchers.is((Object)false));
        config.put("key", (Object)DayOfWeek.MONDAY);
        MatcherAssert.assertThat((Object)config.getStringValue("key", "<unknown>"), (Matcher)CoreMatchers.is((Object)"MONDAY"));
        config.put("key", null);
        MatcherAssert.assertThat((Object)config.containsKey("key"), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void putStringValue() {
        Config config = new Config();
        MatcherAssert.assertThat((Object)config.containsKey("key"), (Matcher)CoreMatchers.is((Object)false));
        config.put("key", (Object)"value");
        MatcherAssert.assertThat((Object)config.getStringValue("key", "<unknown>"), (Matcher)CoreMatchers.is((Object)"value"));
        config.put("key", null);
        MatcherAssert.assertThat((Object)config.containsKey("key"), (Matcher)CoreMatchers.is((Object)false));
    }

    private void assertEmptyConfig(Config config) {
        MatcherAssert.assertThat((Object)config.size(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)config.toString().replaceAll("\\R", ""), (Matcher)CoreMatchers.is((Object)"{}"));
        MatcherAssert.assertThat((Object)config.containsKey("key"), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)config.getStringValue("key", null), (Matcher)CoreMatchers.is((Matcher)Matchers.nullValue()));
    }

    private void assertNotEmptyConfig(Config config) {
        MatcherAssert.assertThat((Object)config.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)config.toString().replaceAll("\\R", ""), (Matcher)CoreMatchers.is((Object)"{  \"key\": \"value\"}"));
        MatcherAssert.assertThat((Object)config.containsKey("key"), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)config.getStringValue("key", null), (Matcher)CoreMatchers.is((Object)"value"));
        MatcherAssert.assertThat((Object)config.containsKey("key1"), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)config.getStringValue("key1", null), (Matcher)CoreMatchers.is((Matcher)Matchers.nullValue()));
    }
}

