/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import schemacrawler.test.utility.DatabaseConnectionInfo;
import schemacrawler.test.utility.DisableLogging;
import schemacrawler.test.utility.WithTestDatabase;
import us.fatehi.utility.datasource.DatabaseConnectionSource;
import us.fatehi.utility.datasource.DatabaseConnectionSources;
import us.fatehi.utility.datasource.MultiUseUserCredentials;
import us.fatehi.utility.datasource.UserCredentials;

@DisableLogging
@WithTestDatabase
public class DatabaseConnectionSourceTest {
    @Test
    public void databaseConnectionSource() throws SQLException, ClassNotFoundException {
        Class.forName("schemacrawler.test.utility.TestDatabaseDriver");
        DatabaseConnectionSource connectionSource = DatabaseConnectionSources.newDatabaseConnectionSource((String)"jdbc:test-db:test", (UserCredentials)new MultiUseUserCredentials());
        Connection connection = (Connection)connectionSource.get();
        MatcherAssert.assertThat((Object)connection, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        Assertions.assertThrows(SQLFeatureNotSupportedException.class, () -> connection.getMetaData());
    }

    @Test
    public void hsqldbConnectionSource(DatabaseConnectionInfo databaseConnectionInfo) throws SQLException, ClassNotFoundException {
        DatabaseConnectionSource connectionSource = DatabaseConnectionSources.newDatabaseConnectionSource((String)databaseConnectionInfo.getConnectionUrl(), (UserCredentials)new MultiUseUserCredentials("sa", ""));
        Connection connection = (Connection)connectionSource.get();
        MatcherAssert.assertThat((Object)connection, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
    }
}

