/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test;

import java.io.FileReader;
import java.io.Reader;
import java.nio.file.Path;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import schemacrawler.schema.Catalog;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import schemacrawler.schemacrawler.SchemaRetrievalOptionsBuilder;
import schemacrawler.schemacrawler.exceptions.ExecutionRuntimeException;
import schemacrawler.schemacrawler.exceptions.InternalRuntimeException;
import schemacrawler.test.utility.DatabaseTestUtility;
import schemacrawler.test.utility.ExecutableTestUtility;
import schemacrawler.test.utility.WithSystemProperty;
import schemacrawler.test.utility.WithTestDatabase;
import schemacrawler.tools.executable.SchemaCrawlerExecutable;
import schemacrawler.tools.options.Config;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.options.OutputOptionsBuilder;
import us.fatehi.utility.IOUtility;
import us.fatehi.utility.datasource.DatabaseConnectionSource;

@WithTestDatabase
public class SchemaCrawlerExecutableTest {
    @Test
    public void executable(DatabaseConnectionSource dataSource) throws Exception {
        Path testOutputFile = IOUtility.createTempFilePath((String)"sc", (String)"data");
        SchemaCrawlerOptions schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions();
        OutputOptions outputOptions = ExecutableTestUtility.newOutputOptions("text", testOutputFile);
        SchemaCrawlerExecutable executable = new SchemaCrawlerExecutable("test-command");
        executable.setSchemaCrawlerOptions(schemaCrawlerOptions);
        executable.setOutputOptions(outputOptions);
        executable.setSchemaRetrievalOptions(DatabaseTestUtility.schemaRetrievalOptionsDefault);
        executable.setDataSource(dataSource);
        executable.execute();
        MatcherAssert.assertThat((Object)("Output generated from schemacrawler.test.utility.testcommand.TestCommand" + System.lineSeparator() + "TestOptions [testCommandParameter=]" + System.lineSeparator()), (Matcher)Matchers.equalTo((Object)IOUtility.readFully((Reader)new FileReader(testOutputFile.toFile()))));
        MatcherAssert.assertThat((Object)executable.toString(), (Matcher)CoreMatchers.is((Object)"test-command"));
        MatcherAssert.assertThat((Object)executable.getOutputOptions(), (Matcher)CoreMatchers.is((Object)outputOptions));
        MatcherAssert.assertThat((Object)executable.getSchemaCrawlerOptions(), (Matcher)CoreMatchers.is((Object)schemaCrawlerOptions));
        Catalog catalog = executable.getCatalog();
        MatcherAssert.assertThat((Object)catalog.getSchemas(), (Matcher)Matchers.hasSize((int)6));
        MatcherAssert.assertThat((Object)catalog.getTables(), (Matcher)Matchers.hasSize((int)19));
    }

    @Test
    @WithSystemProperty(key="SC_WITHOUT_DATABASE_PLUGIN", value="hsqldb")
    public void executable_bad_command(DatabaseConnectionSource dataSource) throws Exception {
        String command1 = "bad-command";
        SchemaCrawlerExecutable executable1 = new SchemaCrawlerExecutable("bad-command");
        executable1.setDataSource(dataSource);
        ExecutionRuntimeException ex1 = (ExecutionRuntimeException)Assertions.assertThrows(ExecutionRuntimeException.class, () -> executable1.execute());
        MatcherAssert.assertThat((Object)ex1.getMessage(), (Matcher)CoreMatchers.is((Object)"Unknown command <bad-command>"));
        String command2 = "test-command";
        SchemaCrawlerExecutable executable2 = new SchemaCrawlerExecutable("test-command");
        executable2.setDataSource(dataSource);
        Config config = new Config();
        config.put("return-null", (Object)"true");
        executable2.setAdditionalConfiguration(config);
        InternalRuntimeException ex2 = (InternalRuntimeException)Assertions.assertThrows(InternalRuntimeException.class, () -> executable2.execute());
        MatcherAssert.assertThat((Object)ex2.getMessage(), (Matcher)CoreMatchers.is((Object)"Cannot run command <test-command>"));
    }

    @Test
    public void executable_options() throws Exception {
        SchemaCrawlerExecutable executable = new SchemaCrawlerExecutable("test-command");
        MatcherAssert.assertThat((Object)executable.getSchemaCrawlerOptions(), (Matcher)CoreMatchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        SchemaCrawlerOptions schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions();
        executable.setSchemaCrawlerOptions(schemaCrawlerOptions);
        MatcherAssert.assertThat((Object)executable.getSchemaCrawlerOptions(), (Matcher)CoreMatchers.is((Matcher)Matchers.sameInstance((Object)schemaCrawlerOptions)));
        executable.setSchemaCrawlerOptions(null);
        MatcherAssert.assertThat((Object)executable.getSchemaCrawlerOptions(), (Matcher)CoreMatchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)executable.getSchemaCrawlerOptions(), (Matcher)CoreMatchers.is((Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)schemaCrawlerOptions))));
        MatcherAssert.assertThat((Object)executable.getOutputOptions(), (Matcher)CoreMatchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        OutputOptions outputOptions = OutputOptionsBuilder.newOutputOptions();
        executable.setOutputOptions(outputOptions);
        MatcherAssert.assertThat((Object)executable.getOutputOptions(), (Matcher)CoreMatchers.is((Matcher)Matchers.sameInstance((Object)outputOptions)));
        executable.setOutputOptions(null);
        MatcherAssert.assertThat((Object)executable.getOutputOptions(), (Matcher)CoreMatchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)executable.getOutputOptions(), (Matcher)CoreMatchers.is((Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)outputOptions))));
        MatcherAssert.assertThat((Object)executable.getSchemaRetrievalOptions(), (Matcher)CoreMatchers.is((Matcher)Matchers.nullValue()));
        SchemaRetrievalOptions schemaRetrievalOptions = SchemaRetrievalOptionsBuilder.newSchemaRetrievalOptions();
        executable.setSchemaRetrievalOptions(schemaRetrievalOptions);
        MatcherAssert.assertThat((Object)executable.getSchemaRetrievalOptions(), (Matcher)CoreMatchers.is((Matcher)Matchers.sameInstance((Object)schemaRetrievalOptions)));
        executable.setSchemaRetrievalOptions(null);
        MatcherAssert.assertThat((Object)executable.getSchemaRetrievalOptions(), (Matcher)CoreMatchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)executable.getSchemaRetrievalOptions(), (Matcher)CoreMatchers.is((Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)schemaRetrievalOptions))));
        MatcherAssert.assertThat((Object)executable.getCatalog(), (Matcher)CoreMatchers.is((Matcher)Matchers.nullValue()));
        Catalog catalog = (Catalog)Mockito.mock(Catalog.class);
        executable.setCatalog(catalog);
        MatcherAssert.assertThat((Object)executable.getCatalog(), (Matcher)CoreMatchers.is((Matcher)Matchers.sameInstance((Object)catalog)));
        executable.setCatalog(null);
        MatcherAssert.assertThat((Object)executable.getCatalog(), (Matcher)CoreMatchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)executable.getCatalog(), (Matcher)CoreMatchers.is((Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)catalog))));
    }

    @Test
    public void executable_with_settings(DatabaseConnectionSource dataSource) throws Exception {
        Path testOutputFile = IOUtility.createTempFilePath((String)"sc", (String)"data");
        Catalog mockCatalog = (Catalog)Mockito.mock(Catalog.class);
        SchemaRetrievalOptions mockSchemaRetrievalOptions = SchemaRetrievalOptionsBuilder.newSchemaRetrievalOptions();
        Config config = new Config();
        config.put("uses-connection", (Object)"false");
        SchemaCrawlerExecutable executable = new SchemaCrawlerExecutable("test-command");
        OutputOptions outputOptions = ExecutableTestUtility.newOutputOptions("text", testOutputFile);
        executable.setOutputOptions(outputOptions);
        executable.setDataSource(dataSource);
        executable.setAdditionalConfiguration(config);
        executable.setCatalog(mockCatalog);
        executable.setSchemaRetrievalOptions(mockSchemaRetrievalOptions);
        executable.execute();
        MatcherAssert.assertThat((Object)("Output generated from schemacrawler.test.utility.testcommand.TestCommand" + System.lineSeparator() + "TestOptions [testCommandParameter=]" + System.lineSeparator()), (Matcher)Matchers.equalTo((Object)IOUtility.readFully((Reader)new FileReader(testOutputFile.toFile()))));
        MatcherAssert.assertThat((Object)executable.toString(), (Matcher)CoreMatchers.is((Object)"test-command"));
        MatcherAssert.assertThat((Object)executable.getCatalog(), (Matcher)CoreMatchers.is((Matcher)Matchers.sameInstance((Object)mockCatalog)));
        MatcherAssert.assertThat((Object)executable.getSchemaRetrievalOptions(), (Matcher)CoreMatchers.is((Matcher)Matchers.sameInstance((Object)mockSchemaRetrievalOptions)));
    }
}

