/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test.utility;

import java.io.Closeable;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.junit.jupiter.api.Assertions;
import schemacrawler.test.utility.DisableLogging;
import schemacrawler.test.utility.TestUtility;
import schemacrawler.testdb.TestSchemaCreator;
import us.fatehi.utility.database.SqlScript;
import us.fatehi.utility.datasource.DatabaseConnectionSource;
import us.fatehi.utility.datasource.DatabaseConnectionSources;

@DisableLogging
public abstract class BaseAdditionalDatabaseTest {
    private DataSource dataSource;

    protected void closeDataSource() {
        try {
            if (this.dataSource instanceof Closeable) {
                ((Closeable)((Object)this.dataSource)).close();
            }
        }
        catch (Exception e) {
            TestUtility.failTestSetup((String)"Could not close data source", (Exception)e);
        }
    }

    protected void createDatabase(String scriptsResource) {
        try (Connection connection = this.getConnection();){
            TestSchemaCreator schemaCreator = new TestSchemaCreator(connection, scriptsResource);
            schemaCreator.run();
        }
        catch (SQLException e) {
            TestUtility.failTestSetup((String)"Could not create database", (Exception)e);
        }
    }

    protected void createDataSource(String connectionUrl, String user, String password) {
        this.createDataSource(connectionUrl, user, password, null);
    }

    protected void createDataSource(String connectionUrl, String user, String password, String connectionProperties) {
        this.dataSource = this.createDataSourceObject(connectionUrl, user, password, connectionProperties);
    }

    protected DataSource createDataSourceObject(String connectionUrl, String user, String password, String connectionProperties) {
        BasicDataSource ds = new BasicDataSource();
        ds.setUrl(connectionUrl);
        ds.setUsername(user);
        ds.setPassword(password);
        if (connectionProperties != null) {
            ds.setConnectionProperties(connectionProperties);
        }
        return ds;
    }

    protected final Connection getConnection() {
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException e) {
            Assertions.fail((String)"Could not get database connection", (Throwable)e);
            return null;
        }
    }

    protected final DatabaseConnectionSource getDataSource() {
        BasicDataSource basicDataSource = (BasicDataSource)this.dataSource;
        return DatabaseConnectionSources.fromDataSource((DataSource)basicDataSource);
    }

    protected void runScript(String databaseSqlResource) throws Exception {
        try (Connection connection = this.getConnection();){
            SqlScript.executeScriptFromResource((String)databaseSqlResource, (Connection)connection);
        }
    }
}

