/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test.utility;

import java.io.Writer;
import java.nio.file.Path;
import org.hamcrest.Matcher;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.inclusionrule.RegularExpressionExclusionRule;
import schemacrawler.schemacrawler.LimitOptionsBuilder;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.test.utility.FileHasContent;
import schemacrawler.test.utility.TestResource;
import schemacrawler.test.utility.TestWriter;
import schemacrawler.tools.executable.SchemaCrawlerExecutable;
import schemacrawler.tools.options.OutputFormat;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.options.OutputOptionsBuilder;
import us.fatehi.utility.datasource.DatabaseConnectionSource;

public final class ExecutableTestUtility {
    public static Path executableExecution(DatabaseConnectionSource dataSource, SchemaCrawlerExecutable executable) throws Exception {
        return ExecutableTestUtility.executableExecution(dataSource, executable, "text");
    }

    public static Path executableExecution(DatabaseConnectionSource dataSource, SchemaCrawlerExecutable executable, OutputFormat outputFormat) throws Exception {
        return ExecutableTestUtility.executableExecution(dataSource, executable, outputFormat.getFormat());
    }

    public static Path executableExecution(DatabaseConnectionSource dataSource, SchemaCrawlerExecutable executable, String outputFormatValue) throws Exception {
        TestWriter testout;
        try (TestWriter out = testout = new TestWriter();){
            OutputOptionsBuilder outputOptionsBuilder = OutputOptionsBuilder.builder((OutputOptions)executable.getOutputOptions()).withOutputFormatValue(outputFormatValue).withOutputWriter((Writer)out);
            executable.setOutputOptions(outputOptionsBuilder.toOptions());
            executable.setDataSource(dataSource);
            executable.execute();
        }
        return testout.getFilePath();
    }

    public static SchemaCrawlerExecutable executableOf(String command) {
        LimitOptionsBuilder limitOptionsBuilder = LimitOptionsBuilder.builder().includeSchemas((InclusionRule)new RegularExpressionExclusionRule(".*\\.FOR_LINT"));
        SchemaCrawlerOptions schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions().withLimitOptions(limitOptionsBuilder.toOptions());
        SchemaCrawlerExecutable executable = new SchemaCrawlerExecutable(command);
        executable.setSchemaCrawlerOptions(schemaCrawlerOptions);
        return executable;
    }

    public static Matcher<TestResource> hasSameContentAndTypeAs(TestResource classpathTestResource, OutputFormat outputFormat) {
        return ExecutableTestUtility.hasSameContentAndTypeAs(classpathTestResource, outputFormat.getFormat());
    }

    public static Matcher<TestResource> hasSameContentAndTypeAs(TestResource classpathTestResource, String outputFormat) {
        return FileHasContent.hasSameContentAndTypeAs((TestResource)classpathTestResource, (String)outputFormat);
    }

    public static OutputOptions newOutputOptions(String outputFormatValue, Path outputFile) {
        return OutputOptionsBuilder.builder().withOutputFormatValue(outputFormatValue).withOutputFile(outputFile).toOptions();
    }

    private ExecutableTestUtility() {
    }
}

