/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test.utility;

import schemacrawler.tools.catalogloader.BaseCatalogLoader;
import schemacrawler.tools.executable.CommandDescription;
import schemacrawler.tools.executable.commandline.PluginCommand;

public class TestCatalogLoader
extends BaseCatalogLoader {
    public TestCatalogLoader() {
        super(new CommandDescription("testloader", "Loader for testing"), 3);
        this.forceInstantiationFailureIfConfigured();
    }

    public PluginCommand getCommandLineCommand() {
        CommandDescription commandDescription = this.getCommandDescription();
        PluginCommand pluginCommand = PluginCommand.newCatalogLoaderCommand((String)commandDescription.getName(), (String)commandDescription.getDescription());
        pluginCommand.addOption("test-load-option", Boolean.class, new String[]{"Check that the test option is added to the load command"});
        return pluginCommand;
    }

    public void loadCatalog() {
        this.forceLoadFailureIfConfigured();
    }

    private void forceInstantiationFailureIfConfigured() {
        String propertyValue = System.getProperty(((Object)((Object)this)).getClass().getName() + ".force-instantiation-failure");
        if (propertyValue != null) {
            throw new RuntimeException("Forced instantiation error");
        }
    }

    private void forceLoadFailureIfConfigured() {
        String propertyValue = System.getProperty(((Object)((Object)this)).getClass().getName() + ".force-load-failure");
        if (propertyValue != null) {
            System.exit(2);
        }
    }
}

