/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test.utility;

import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import us.fatehi.utility.Utility;

public class TestDatabaseDriver
implements Driver {
    private static final String JDBC_URL_PREFIX = "jdbc:test-db:";

    private static Connection newConnection() {
        return (Connection)Proxy.newProxyInstance(TestDatabaseDriver.class.getClassLoader(), new Class[]{Connection.class}, (proxy, method, args) -> {
            String methodName;
            switch (methodName = method.getName()) {
                case "close": 
                case "setAutoCommit": {
                    return null;
                }
                case "isWrapperFor": {
                    return false;
                }
                case "isValid": {
                    return true;
                }
                case "getDatabaseProductName": 
                case "getDriverName": 
                case "toString": {
                    return "TestDatabaseDriver";
                }
                case "getDatabaseProductVersion": 
                case "getDriverVersion": {
                    return "0.0";
                }
            }
            throw new SQLFeatureNotSupportedException(methodName);
        });
    }

    @Override
    public boolean acceptsURL(String url) {
        return !Utility.isBlank((CharSequence)url) && url.startsWith(JDBC_URL_PREFIX);
    }

    @Override
    public Connection connect(String url, Properties info) {
        if (this.acceptsURL(url)) {
            return TestDatabaseDriver.newConnection();
        }
        return null;
    }

    @Override
    public int getMajorVersion() {
        return 0;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("Not supported", "HYC00");
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        return new DriverPropertyInfo[0];
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    static {
        try {
            DriverManager.registerDriver(new TestDatabaseDriver());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

