/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.catalogloader;

import java.sql.Connection;
import java.sql.SQLException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.test.utility.DatabaseTestUtility;
import schemacrawler.test.utility.TestDatabaseDriver;
import schemacrawler.tools.catalogloader.SchemaCrawlerCatalogLoader;
import us.fatehi.utility.datasource.DatabaseConnectionSource;
import us.fatehi.utility.datasource.DatabaseConnectionSourceUtility;

public class SchemaCrawlerCatalogLoaderTest {
    @Test
    public void connection() throws SQLException {
        SchemaCrawlerCatalogLoader catalogLoader = new SchemaCrawlerCatalogLoader();
        MatcherAssert.assertThat((Object)catalogLoader.getDataSource(), (Matcher)CoreMatchers.is((Matcher)Matchers.nullValue()));
        Connection connection = new TestDatabaseDriver().connect("jdbc:test-db:test", null);
        DatabaseConnectionSource dataSource = DatabaseConnectionSourceUtility.newTestDatabaseConnectionSource((Connection)connection);
        catalogLoader.setDataSource(dataSource);
        MatcherAssert.assertThat((Object)catalogLoader.getDataSource(), (Matcher)CoreMatchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        connection.close();
    }

    @Test
    public void schemaCrawlerOptions() {
        SchemaCrawlerCatalogLoader catalogLoader = new SchemaCrawlerCatalogLoader();
        MatcherAssert.assertThat((Object)catalogLoader.getSchemaCrawlerOptions(), (Matcher)CoreMatchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        SchemaCrawlerOptions schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions();
        catalogLoader.setSchemaCrawlerOptions(schemaCrawlerOptions);
        MatcherAssert.assertThat((Object)catalogLoader.getSchemaCrawlerOptions(), (Matcher)CoreMatchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)catalogLoader.getSchemaCrawlerOptions().equals(schemaCrawlerOptions), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void schemaRetrievalOptions() {
        SchemaCrawlerCatalogLoader catalogLoader = new SchemaCrawlerCatalogLoader();
        MatcherAssert.assertThat((Object)catalogLoader.getSchemaRetrievalOptions(), (Matcher)CoreMatchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        catalogLoader.setSchemaRetrievalOptions(DatabaseTestUtility.schemaRetrievalOptionsDefault);
        MatcherAssert.assertThat((Object)catalogLoader.getSchemaRetrievalOptions(), (Matcher)CoreMatchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)catalogLoader.getSchemaRetrievalOptions().equals(DatabaseTestUtility.schemaRetrievalOptionsDefault), (Matcher)CoreMatchers.is((Object)true));
    }
}

