/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.databaseconnector;

import java.sql.Connection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.test.utility.DisableLogging;
import schemacrawler.test.utility.TestDatabaseConnector;
import schemacrawler.tools.databaseconnector.DatabaseConnectionOptions;
import schemacrawler.tools.databaseconnector.DatabaseConnector;
import schemacrawler.tools.databaseconnector.DatabaseServerHostConnectionOptions;
import schemacrawler.tools.executable.commandline.PluginCommand;
import us.fatehi.utility.datasource.DatabaseConnectionSource;
import us.fatehi.utility.datasource.MultiUseUserCredentials;
import us.fatehi.utility.datasource.UserCredentials;

@DisableLogging
public class DatabaseConnectorTest {
    @Test
    public void databaseConnector() throws Exception {
        TestDatabaseConnector databaseConnector = new TestDatabaseConnector();
        MatcherAssert.assertThat((Object)databaseConnector.getDatabaseServerType().getDatabaseSystemIdentifier(), (Matcher)CoreMatchers.is((Object)"test-db"));
        MatcherAssert.assertThat((Object)databaseConnector.getHelpCommand().getName(), (Matcher)CoreMatchers.is((Object)"server:test-db"));
        DatabaseServerHostConnectionOptions connectionOptions = new DatabaseServerHostConnectionOptions("test-db", "some-host", Integer.valueOf(2121), "some-database", null);
        DatabaseConnectionSource connectionSource = databaseConnector.newDatabaseConnectionSource((DatabaseConnectionOptions)connectionOptions, (UserCredentials)new MultiUseUserCredentials());
        MatcherAssert.assertThat((Object)databaseConnector.getSchemaRetrievalOptionsBuilder((Connection)connectionSource.get()), (Matcher)CoreMatchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        SchemaCrawlerOptions schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions();
        MatcherAssert.assertThat((Object)databaseConnector.setSchemaCrawlerOptionsDefaults(schemaCrawlerOptions), (Matcher)CoreMatchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)databaseConnector.supportsUrl("jdbc:test-db:some-database"), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testDatabaseConnector() throws Exception {
        TestDatabaseConnector databaseConnector = new TestDatabaseConnector();
        PluginCommand helpCommand = databaseConnector.getHelpCommand();
        MatcherAssert.assertThat((Object)helpCommand, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)helpCommand.getName(), (Matcher)CoreMatchers.is((Object)"server:test-db"));
        MatcherAssert.assertThat((Object)databaseConnector.getDatabaseServerType().getDatabaseSystemIdentifier(), (Matcher)CoreMatchers.is((Object)"test-db"));
        MatcherAssert.assertThat((Object)databaseConnector.supportsUrl("jdbc:test-db:somevalue"), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)databaseConnector.supportsUrl("jdbc:newdb:somevalue"), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)databaseConnector.supportsUrl(null), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)databaseConnector.toString(), (Matcher)CoreMatchers.is((Object)"Database connector for test-db - Test Database"));
    }

    @Test
    public void unknownDatabaseConnector() {
        DatabaseConnector databaseConnector = DatabaseConnector.UNKNOWN;
        PluginCommand helpCommand = databaseConnector.getHelpCommand();
        MatcherAssert.assertThat((Object)helpCommand, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)helpCommand.getName(), (Matcher)CoreMatchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)databaseConnector.getDatabaseServerType().getDatabaseSystemIdentifier(), (Matcher)CoreMatchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)databaseConnector.supportsUrl("jdbc:newdb:somevalue"), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)databaseConnector.supportsUrl(null), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)databaseConnector.toString(), (Matcher)CoreMatchers.is((Object)"Database connector for unknown database system type"));
    }
}

