/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable.commandline;

import com.openpojo.reflection.impl.PojoClassFactory;
import com.openpojo.validation.Validator;
import com.openpojo.validation.ValidatorBuilder;
import com.openpojo.validation.rule.Rule;
import com.openpojo.validation.rule.impl.GetterMustExistRule;
import com.openpojo.validation.test.Tester;
import com.openpojo.validation.test.impl.GetterTester;
import nl.jqno.equalsverifier.EqualsVerifier;
import nl.jqno.equalsverifier.Warning;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import schemacrawler.tools.executable.commandline.PluginCommand;
import schemacrawler.tools.executable.commandline.PluginCommandOption;

public class PluginCommandPojoTest {
    @Test
    public void emptyCommand() {
        PluginCommand pluginCommand = PluginCommand.empty();
        MatcherAssert.assertThat((Object)pluginCommand.toString(), (Matcher)CoreMatchers.is((Object)"PluginCommand[name='null', options=[]]"));
        MatcherAssert.assertThat((Object)pluginCommand.getName(), (Matcher)CoreMatchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)pluginCommand.getHelpHeader(), (Matcher)CoreMatchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)pluginCommand.getHelpDescription(), (Matcher)CoreMatchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat(pluginCommand.getHelpFooter().get(), (Matcher)CoreMatchers.is((Matcher)Matchers.arrayWithSize((int)0)));
        MatcherAssert.assertThat((Object)pluginCommand.getOptions(), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)pluginCommand.hasHelpDescription(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)pluginCommand.hasHelpFooter(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)pluginCommand.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void newCatalogLoaderCommand() {
        PluginCommand pluginCommand = PluginCommand.newCatalogLoaderCommand((String)"name", (String)"helpHeader");
        pluginCommand.addOption("option1", Object.class, new String[]{"helpOption1", "helpOption2"});
        this.assertPluginCommandValues(pluginCommand, "Add loader options to the `load` command in the SchemaCrawler Shell");
    }

    @Test
    public void newDatabasePluginCommand() {
        PluginCommand pluginCommand = PluginCommand.newDatabasePluginCommand((String)"name", (String)"helpHeader");
        pluginCommand.addOption("option1", Object.class, new String[]{"helpOption1", "helpOption2"});
        this.assertPluginCommandValues(pluginCommand, "Add connection options to the `connect` command in the SchemaCrawler Shell");
    }

    @Test
    public void newPluginCommand() {
        PluginCommand pluginCommand = PluginCommand.newPluginCommand((String)"name", (String)"helpHeader");
        pluginCommand.addOption("option1", Object.class, new String[]{"helpOption1", "helpOption2"});
        this.assertPluginCommandValues(pluginCommand, "Add command options to the `execute` command in the SchemaCrawler Shell");
    }

    @Test
    public void pluginCommand() {
        EqualsVerifier.forClass(PluginCommand.class).suppress(new Warning[]{Warning.STRICT_INHERITANCE}).withOnlyTheseFields(new String[]{"name"}).verify();
        PluginCommand pluginCommand = PluginCommand.newDatabasePluginCommand((String)"name", (String)"helpHeader");
        MatcherAssert.assertThat((Object)pluginCommand.toString(), (Matcher)CoreMatchers.is((Object)"PluginCommand[name='name', options=[]]"));
    }

    @Test
    public void pluginCommandExtraMethods() {
        PluginCommand pluginCommand = PluginCommand.newPluginCommand((String)"name", (String)"helpHeader", () -> new String[]{"helpDescription1", "helpDescription2"}, () -> new String[]{"helpFooter1", "helpFooter2"});
        MatcherAssert.assertThat((Object)pluginCommand.toString(), (Matcher)CoreMatchers.is((Object)"PluginCommand[name='name', options=[]]"));
        MatcherAssert.assertThat((Object)pluginCommand.getName(), (Matcher)Matchers.endsWith((String)":name"));
        MatcherAssert.assertThat((Object)pluginCommand.getHelpHeader(), (Matcher)CoreMatchers.is((Object)"helpHeader"));
        MatcherAssert.assertThat(pluginCommand.getHelpDescription().get(), (Matcher)CoreMatchers.is((Matcher)Matchers.arrayContaining((Object[])new String[]{"helpDescription1", "helpDescription2"})));
        MatcherAssert.assertThat(pluginCommand.getHelpFooter().get(), (Matcher)CoreMatchers.is((Matcher)Matchers.arrayContaining((Object[])new String[]{"helpFooter1", "helpFooter2", "Add command options to the `execute` command in the SchemaCrawler Shell"})));
        MatcherAssert.assertThat((Object)pluginCommand.getOptions(), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)pluginCommand.hasHelpDescription(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)pluginCommand.hasHelpFooter(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)pluginCommand.isEmpty(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void pluginCommandOption() {
        EqualsVerifier.forClass(PluginCommandOption.class).suppress(new Warning[]{Warning.STRICT_INHERITANCE}).withOnlyTheseFields(new String[]{"name"}).verify();
        Validator validator = ValidatorBuilder.create().with(new Rule[]{new GetterMustExistRule()}).with(new Tester[]{new GetterTester()}).build();
        validator.validate(PojoClassFactory.getPojoClass(PluginCommandOption.class));
        PluginCommandOption pluginCommandOption = new PluginCommandOption("name", this.getClass(), new String[]{"helpText"});
        MatcherAssert.assertThat((Object)pluginCommandOption.toString(), (Matcher)CoreMatchers.is((Object)"PluginCommandOption[name='name', valueClass=schemacrawler.tools.executable.commandline.PluginCommandPojoTest]"));
    }

    @Test
    public void pluginCommandOptionEmpty() {
        PluginCommandOption pluginCommandOption = new PluginCommandOption("option1", (Class)null, (String[])null);
        MatcherAssert.assertThat((Object)pluginCommandOption.getValueClass(), (Matcher)CoreMatchers.is(String.class));
        MatcherAssert.assertThat((Object)pluginCommandOption.getHelpText(), (Matcher)CoreMatchers.is((Matcher)Matchers.arrayWithSize((int)0)));
    }

    private void assertPluginCommandValues(PluginCommand pluginCommand, String standardFooter) {
        PluginCommandOption option = new PluginCommandOption("option1", Object.class, new String[]{"helpOption1", "helpOption2"});
        MatcherAssert.assertThat((Object)pluginCommand.toString(), (Matcher)CoreMatchers.is((Object)"PluginCommand[name='name', options=[PluginCommandOption[name='option1', valueClass=java.lang.Object]]]"));
        MatcherAssert.assertThat((Object)pluginCommand.getName(), (Matcher)Matchers.endsWith((String)":name"));
        MatcherAssert.assertThat((Object)pluginCommand.getHelpHeader(), (Matcher)CoreMatchers.is((Object)"helpHeader"));
        MatcherAssert.assertThat((Object)pluginCommand.getHelpDescription(), (Matcher)CoreMatchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat(pluginCommand.getHelpFooter().get(), (Matcher)CoreMatchers.is((Matcher)Matchers.arrayContaining((Object[])new String[]{standardFooter})));
        MatcherAssert.assertThat((Object)pluginCommand.getOptions(), (Matcher)Matchers.contains((Object[])new PluginCommandOption[]{option}));
        MatcherAssert.assertThat((Object)pluginCommand.hasHelpDescription(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)pluginCommand.hasHelpFooter(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)pluginCommand.isEmpty(), (Matcher)CoreMatchers.is((Object)false));
        for (PluginCommandOption pluginCommandOption : pluginCommand) {
            MatcherAssert.assertThat((Object)pluginCommandOption, (Matcher)CoreMatchers.is((Object)option));
        }
    }
}

