/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import java.sql.Connection;
import java.util.Objects;
import schemacrawler.schema.Catalog;
import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.tools.executable.SchemaCrawlerCommand;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.options.OutputOptionsBuilder;
import schemacrawler.utility.Identifiers;
import sf.util.ObjectToString;
import sf.util.Utility;

public abstract class BaseSchemaCrawlerCommand
implements SchemaCrawlerCommand {
    protected final String command;
    protected Config additionalConfiguration;
    protected Catalog catalog;
    protected Connection connection;
    protected Identifiers identifiers;
    protected OutputOptions outputOptions;
    protected SchemaCrawlerOptions schemaCrawlerOptions;

    protected BaseSchemaCrawlerCommand(String command) {
        if (Utility.isBlank((CharSequence)command)) {
            throw new IllegalArgumentException("No command specified");
        }
        this.command = command;
        this.schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions();
        this.outputOptions = OutputOptionsBuilder.newOutputOptions();
        this.additionalConfiguration = new Config();
    }

    @Override
    public void checkAvailability() throws Exception {
    }

    @Override
    public final Config getAdditionalConfiguration() {
        return this.additionalConfiguration;
    }

    @Override
    public final void setAdditionalConfiguration(Config additionalConfiguration) {
        this.additionalConfiguration = Objects.requireNonNull(additionalConfiguration, "No additional configuration provided");
    }

    @Override
    public Catalog getCatalog() {
        return this.catalog;
    }

    @Override
    public void setCatalog(Catalog catalog) {
        this.catalog = catalog;
    }

    @Override
    public final String getCommand() {
        return this.command;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    @Override
    public Identifiers getIdentifiers() {
        return this.identifiers;
    }

    @Override
    public void setIdentifiers(Identifiers identifiers) {
        this.identifiers = identifiers;
    }

    @Override
    public final OutputOptions getOutputOptions() {
        return this.outputOptions;
    }

    @Override
    public final void setOutputOptions(OutputOptions outputOptions) {
        this.outputOptions = outputOptions != null ? outputOptions : OutputOptionsBuilder.newOutputOptions();
    }

    @Override
    public final SchemaCrawlerOptions getSchemaCrawlerOptions() {
        return this.schemaCrawlerOptions;
    }

    @Override
    public final void setSchemaCrawlerOptions(SchemaCrawlerOptions schemaCrawlerOptions) {
        this.schemaCrawlerOptions = schemaCrawlerOptions != null ? schemaCrawlerOptions : SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions();
    }

    @Override
    public void initialize() throws Exception {
        this.checkOptions();
    }

    public final String toString() {
        return ObjectToString.toString((Object)this);
    }

    protected void checkCatalog() {
        Objects.requireNonNull(this.catalog, "No database catalog provided");
        if (this.usesConnection()) {
            Objects.requireNonNull(this.connection, "No database connection provided");
        }
    }

    private void checkOptions() {
        Objects.requireNonNull(this.schemaCrawlerOptions, "No SchemaCrawler options provided");
        Objects.requireNonNull(this.additionalConfiguration, "No additional configuration provided");
        Objects.requireNonNull(this.outputOptions, "No output options provided");
        Objects.requireNonNull(this.identifiers, "No database identifiers provided");
    }
}

