/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import java.util.logging.Level;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerRuntimeException;
import schemacrawler.tools.executable.CommandDescription;
import schemacrawler.tools.executable.CommandProvider;
import schemacrawler.tools.executable.OperationCommandProvider;
import schemacrawler.tools.executable.SchemaCrawlerCommand;
import schemacrawler.tools.executable.SchemaTextCommandProvider;
import schemacrawler.tools.executable.commandline.PluginCommand;
import schemacrawler.tools.options.OutputOptions;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;

public final class CommandRegistry {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger((String)CommandRegistry.class.getName());
    private static CommandRegistry commandRegistrySingleton;
    private final List<CommandProvider> commandRegistry = CommandRegistry.loadCommandRegistry();

    public static CommandRegistry getCommandRegistry() throws SchemaCrawlerException {
        if (commandRegistrySingleton == null) {
            commandRegistrySingleton = new CommandRegistry();
        }
        return commandRegistrySingleton;
    }

    private static List<CommandProvider> loadCommandRegistry() throws SchemaCrawlerException {
        ArrayList<CommandProvider> commandProviders = new ArrayList<CommandProvider>();
        commandProviders.add(new SchemaTextCommandProvider());
        commandProviders.add(new OperationCommandProvider());
        try {
            ServiceLoader<CommandProvider> serviceLoader = ServiceLoader.load(CommandProvider.class);
            for (CommandProvider commandProvider : serviceLoader) {
                LOGGER.log(Level.CONFIG, (Supplier)new StringFormat("Loading command %s, provided by %s", new Object[]{commandProvider.getSupportedCommands(), commandProvider.getClass().getName()}));
                commandProviders.add(commandProvider);
            }
        }
        catch (Exception e) {
            throw new SchemaCrawlerException("Could not load extended command registry", (Throwable)e);
        }
        return commandProviders;
    }

    private CommandRegistry() throws SchemaCrawlerException {
    }

    public Collection<PluginCommand> getCommandLineCommands() {
        HashSet<PluginCommand> commandLineCommands = new HashSet<PluginCommand>();
        for (CommandProvider commandProvider : this.commandRegistry) {
            commandLineCommands.add(commandProvider.getCommandLineCommand());
        }
        return commandLineCommands;
    }

    public Collection<CommandDescription> getSupportedCommands() {
        HashSet<CommandDescription> supportedCommandDescriptions = new HashSet<CommandDescription>();
        for (CommandProvider commandProvider : this.commandRegistry) {
            supportedCommandDescriptions.addAll(commandProvider.getSupportedCommands());
        }
        ArrayList<CommandDescription> supportedCommandsOrdered = new ArrayList<CommandDescription>(supportedCommandDescriptions);
        supportedCommandsOrdered.sort(Comparator.naturalOrder());
        return supportedCommandsOrdered;
    }

    SchemaCrawlerCommand configureNewCommand(String command, SchemaCrawlerOptions schemaCrawlerOptions, OutputOptions outputOptions) throws SchemaCrawlerException {
        SchemaCrawlerCommand scCommand;
        CommandProvider executableCommandProvider = null;
        for (CommandProvider commandProvider : this.commandRegistry) {
            if (!commandProvider.supportsSchemaCrawlerCommand(command, schemaCrawlerOptions, outputOptions)) continue;
            executableCommandProvider = commandProvider;
            break;
        }
        if (executableCommandProvider == null) {
            executableCommandProvider = new OperationCommandProvider();
        }
        try {
            scCommand = executableCommandProvider.newSchemaCrawlerCommand(command);
            scCommand.setSchemaCrawlerOptions(schemaCrawlerOptions);
            scCommand.setOutputOptions(outputOptions);
        }
        catch (Throwable e) {
            LOGGER.log(Level.CONFIG, e.getMessage(), e);
            throw new SchemaCrawlerRuntimeException(String.format("Cannot run command <%s>", command));
        }
        return scCommand;
    }
}

