/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable.commandline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.StringJoiner;
import schemacrawler.tools.executable.commandline.PluginCommandOption;
import sf.util.Utility;

public class PluginCommand
implements Iterable<PluginCommandOption> {
    private final String helpDescription;
    private final String helpHeader;
    private final String name;
    private final Collection<PluginCommandOption> options;

    public static PluginCommand empty() {
        return new PluginCommand(null, null);
    }

    private PluginCommand(String name, String helpHeader, String helpDescription, Collection<PluginCommandOption> options) {
        this.options = options == null ? new ArrayList<PluginCommandOption>() : new HashSet<PluginCommandOption>(options);
        if (Utility.isBlank((CharSequence)name) && !this.options.isEmpty()) {
            throw new IllegalArgumentException("No command name provided");
        }
        this.name = name;
        this.helpHeader = Utility.isBlank((CharSequence)helpHeader) ? null : helpHeader;
        this.helpDescription = Utility.isBlank((CharSequence)helpDescription) ? null : helpDescription;
    }

    public PluginCommand(String name, String helpHeader) {
        this(name, helpHeader, null, null);
    }

    public PluginCommand(String name, String helpHeader, String helpDescription) {
        this(name, helpHeader, helpDescription, null);
    }

    public String getHelpDescription() {
        return this.helpDescription;
    }

    public String getHelpHeader() {
        return this.helpHeader;
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PluginCommand)) {
            return false;
        }
        PluginCommand that = (PluginCommand)o;
        return Objects.equals(this.name, that.name);
    }

    @Override
    public Iterator<PluginCommandOption> iterator() {
        return this.options.iterator();
    }

    public boolean isEmpty() {
        return Utility.isBlank((CharSequence)this.name) && this.options.isEmpty();
    }

    public PluginCommand addOption(String name, String helpText, Class<?> valueClass) {
        PluginCommandOption option = new PluginCommandOption(name, helpText, valueClass);
        if (option != null) {
            this.options.add(option);
        }
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return new StringJoiner(", ", PluginCommand.class.getSimpleName() + "[", "]").add("name='" + this.name + "'").add("options=" + this.options).toString();
    }
}

