/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.catalogloader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schemacrawler.exceptions.InternalRuntimeException;
import schemacrawler.tools.catalogloader.CatalogLoader;
import schemacrawler.tools.catalogloader.ChainedCatalogLoader;
import schemacrawler.tools.executable.commandline.PluginCommand;
import schemacrawler.tools.registry.BasePluginRegistry;
import schemacrawler.tools.registry.PluginCommandRegistry;
import us.fatehi.utility.property.PropertyName;
import us.fatehi.utility.string.StringFormat;

public final class CatalogLoaderRegistry
extends BasePluginRegistry
implements PluginCommandRegistry {
    private static final Logger LOGGER = Logger.getLogger(CatalogLoaderRegistry.class.getName());
    private static CatalogLoaderRegistry catalogLoaderRegistrySingleton;
    private final List<CatalogLoader> catalogLoaderRegistry = CatalogLoaderRegistry.loadCatalogLoaderRegistry();

    public static CatalogLoaderRegistry getCatalogLoaderRegistry() {
        if (catalogLoaderRegistrySingleton == null) {
            catalogLoaderRegistrySingleton = new CatalogLoaderRegistry();
        }
        catalogLoaderRegistrySingleton.log();
        return catalogLoaderRegistrySingleton;
    }

    private static List<CatalogLoader> loadCatalogLoaderRegistry() {
        CopyOnWriteArrayList<CatalogLoader> catalogLoaderRegistry = new CopyOnWriteArrayList<CatalogLoader>();
        try {
            ServiceLoader<CatalogLoader> serviceLoader = ServiceLoader.load(CatalogLoader.class, CatalogLoaderRegistry.class.getClassLoader());
            for (CatalogLoader catalogLoader : serviceLoader) {
                LOGGER.log(Level.CONFIG, (Supplier<String>)new StringFormat("Loading catalog loader, %s", new Object[]{catalogLoader.getClass().getName()}));
                catalogLoaderRegistry.add(catalogLoader);
            }
        }
        catch (Throwable e) {
            throw new InternalRuntimeException("Could not load catalog loader registry", e);
        }
        Collections.sort(catalogLoaderRegistry);
        return catalogLoaderRegistry;
    }

    private CatalogLoaderRegistry() {
    }

    @Override
    public Collection<PluginCommand> getCommandLineCommands() {
        HashSet<PluginCommand> commandLineCommands = new HashSet<PluginCommand>();
        for (CatalogLoader catalogLoader : this.catalogLoaderRegistry) {
            commandLineCommands.add(catalogLoader.getCommandLineCommand());
        }
        return commandLineCommands;
    }

    @Override
    public Collection<PluginCommand> getHelpCommands() {
        HashSet<PluginCommand> commandLineCommands = new HashSet<PluginCommand>();
        for (CatalogLoader catalogLoader : this.catalogLoaderRegistry) {
            commandLineCommands.add(catalogLoader.getHelpCommand());
        }
        return commandLineCommands;
    }

    @Override
    public Collection<PropertyName> getRegisteredPlugins() {
        ArrayList<PropertyName> commandLineCommands = new ArrayList<PropertyName>();
        for (CatalogLoader catalogLoader : this.catalogLoaderRegistry) {
            PropertyName catalogLoaderName = catalogLoader.getCatalogLoaderName();
            commandLineCommands.add(catalogLoaderName);
        }
        return commandLineCommands;
    }

    public ChainedCatalogLoader newChainedCatalogLoader() {
        ArrayList<CatalogLoader> chainedCatalogLoaders = new ArrayList<CatalogLoader>(this.catalogLoaderRegistry);
        return new ChainedCatalogLoader(chainedCatalogLoaders);
    }

    @Override
    public String getName() {
        return "SchemaCrawler Catalog Loaders";
    }
}

