/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import java.sql.Connection;
import java.util.Objects;
import schemacrawler.schema.Catalog;
import schemacrawler.schemacrawler.exceptions.ExecutionRuntimeException;
import schemacrawler.tools.executable.Command;
import us.fatehi.utility.property.PropertyName;

public abstract class BaseCommand<C, R>
implements Command<C, R> {
    protected final PropertyName command;
    protected C commandOptions;
    protected Catalog catalog;
    protected Connection connection;

    protected BaseCommand(PropertyName command) {
        this.command = Objects.requireNonNull(command, "No command specified");
    }

    @Override
    public void configure(C commandOptions) {
        this.commandOptions = Objects.requireNonNull(commandOptions, "No command options provided");
    }

    @Override
    public final Catalog getCatalog() {
        return this.catalog;
    }

    @Override
    public final Connection getConnection() {
        return this.connection;
    }

    @Override
    public final PropertyName getCommandName() {
        return this.command;
    }

    @Override
    public void initialize() {
    }

    @Override
    public final void setCatalog(Catalog catalog) {
        this.catalog = Objects.requireNonNull(catalog, "No catalog provided");
    }

    @Override
    public final void setConnection(Connection connection) {
        if (!this.usesConnection()) {
            throw new ExecutionRuntimeException(String.format("<%s> does not use a connection", this.command.getName()));
        }
        this.connection = connection;
    }

    public String toString() {
        return this.command.toString();
    }
}

