/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.utility;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import schemacrawler.crawl.ResultsCrawler;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.ResultsColumns;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import schemacrawler.schemacrawler.SchemaRetrievalOptionsBuilder;
import schemacrawler.schemacrawler.exceptions.DatabaseAccessException;
import schemacrawler.schemacrawler.exceptions.InternalRuntimeException;
import schemacrawler.tools.catalogloader.CatalogLoaderRegistry;
import schemacrawler.tools.catalogloader.ChainedCatalogLoader;
import schemacrawler.tools.databaseconnector.DatabaseConnector;
import schemacrawler.tools.databaseconnector.DatabaseConnectorRegistry;
import schemacrawler.tools.databaseconnector.UnknownDatabaseConnector;
import schemacrawler.tools.options.Config;
import us.fatehi.utility.PropertiesUtility;
import us.fatehi.utility.Utility;
import us.fatehi.utility.database.DatabaseUtility;
import us.fatehi.utility.datasource.DatabaseConnectionSource;
import us.fatehi.utility.datasource.DatabaseServerType;
import us.fatehi.utility.string.ObjectToStringFormat;
import us.fatehi.utility.string.StringFormat;

public final class SchemaCrawlerUtility {
    private static final Logger LOGGER = Logger.getLogger(SchemaCrawlerUtility.class.getName());

    public static Catalog getCatalog(DatabaseConnectionSource dataSource, SchemaCrawlerOptions schemaCrawlerOptions) {
        SchemaRetrievalOptions schemaRetrievalOptions = SchemaCrawlerUtility.matchSchemaRetrievalOptions(dataSource);
        return SchemaCrawlerUtility.getCatalog(dataSource, schemaRetrievalOptions, schemaCrawlerOptions, new Config());
    }

    public static Catalog getCatalog(DatabaseConnectionSource dataSource, SchemaRetrievalOptions schemaRetrievalOptions, SchemaCrawlerOptions schemaCrawlerOptions, Config additionalConfig) {
        LOGGER.log(Level.CONFIG, (Supplier<String>)new ObjectToStringFormat((Object)schemaCrawlerOptions));
        SchemaCrawlerUtility.updateConnectionDataSource(dataSource, schemaRetrievalOptions);
        CatalogLoaderRegistry catalogLoaderRegistry = CatalogLoaderRegistry.getCatalogLoaderRegistry();
        ChainedCatalogLoader catalogLoader = catalogLoaderRegistry.newChainedCatalogLoader();
        LOGGER.log(Level.CONFIG, (Supplier<String>)new StringFormat("Catalog loader: %s", new Object[]{catalogLoader}));
        catalogLoader.setDataSource(dataSource);
        catalogLoader.setSchemaRetrievalOptions(schemaRetrievalOptions);
        catalogLoader.setSchemaCrawlerOptions(schemaCrawlerOptions);
        catalogLoader.setAdditionalConfiguration(additionalConfig);
        catalogLoader.loadCatalog();
        Catalog catalog = catalogLoader.getCatalog();
        Objects.requireNonNull(catalog, "Catalog could not be retrieved");
        return catalog;
    }

    public static ResultsColumns getResultsColumns(ResultSet resultSet) {
        try {
            SchemaCrawlerUtility.checkResultSet(resultSet);
            ResultsCrawler resultSetCrawler = new ResultsCrawler(resultSet);
            ResultsColumns resultsColumns = resultSetCrawler.crawl();
            return resultsColumns;
        }
        catch (SQLException e) {
            throw new DatabaseAccessException("Could not retrieve result-set metadata", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SchemaRetrievalOptions matchSchemaRetrievalOptions(DatabaseConnectionSource dataSource) {
        try (Connection connection = (Connection)dataSource.get();){
            SchemaRetrievalOptions schemaRetrievalOptions;
            SchemaRetrievalOptionsBuilder schemaRetrievalOptionsBuilder = SchemaCrawlerUtility.buildSchemaRetrievalOptions(connection);
            SchemaRetrievalOptions schemaRetrievalOptions2 = schemaRetrievalOptions = schemaRetrievalOptionsBuilder.toOptions();
            return schemaRetrievalOptions2;
        }
        catch (SQLException e) {
            throw new InternalRuntimeException("Could not obtain schema retrieval options", (Throwable)e);
        }
    }

    public static void updateConnectionDataSource(DatabaseConnectionSource dataSource, SchemaRetrievalOptions schemaRetrievalOptions) {
        if (dataSource == null) {
            LOGGER.log(Level.CONFIG, "No database connection source provided");
            return;
        }
        if (schemaRetrievalOptions == null) {
            LOGGER.log(Level.CONFIG, "No schema retrieval options provided");
            return;
        }
        dataSource.setFirstConnectionInitializer(schemaRetrievalOptions.getConnectionInitializer());
    }

    private static SchemaRetrievalOptionsBuilder buildSchemaRetrievalOptions(Connection connection) {
        SchemaCrawlerUtility.checkConnection(connection);
        DatabaseConnectorRegistry registry = DatabaseConnectorRegistry.getDatabaseConnectorRegistry();
        DatabaseConnector dbConnector = registry.findDatabaseConnector(connection);
        DatabaseServerType databaseServerType = dbConnector.getDatabaseServerType();
        if (databaseServerType.isUnknownDatabaseSystem()) {
            LOGGER.log(Level.INFO, "Not using any SchemaCrawler database plugin");
        } else {
            LOGGER.log(Level.INFO, "Using SchemaCrawler database plugin for " + databaseServerType);
        }
        boolean useMatchedDatabasePlugin = SchemaCrawlerUtility.useMatchedDatabasePlugin(connection, databaseServerType);
        if (!useMatchedDatabasePlugin) {
            dbConnector = UnknownDatabaseConnector.UNKNOWN;
        }
        SchemaRetrievalOptionsBuilder schemaRetrievalOptionsBuilder = dbConnector.getSchemaRetrievalOptionsBuilder(connection);
        return schemaRetrievalOptionsBuilder;
    }

    private static void checkConnection(Connection connection) {
        try {
            DatabaseUtility.checkConnection((Connection)connection);
        }
        catch (SQLException e) {
            throw new InternalRuntimeException("Bad database connection", (Throwable)e);
        }
    }

    private static void checkResultSet(ResultSet resultSet) {
        try {
            DatabaseUtility.checkResultSet((ResultSet)resultSet);
        }
        catch (SQLException e) {
            throw new DatabaseAccessException("Bad result-set", e);
        }
    }

    private static String extractDatabaseServerTypeFromUrl(String url) {
        String urlDBServerType;
        Pattern urlPattern = Pattern.compile("jdbc:(.*?):.*");
        Matcher matcher = urlPattern.matcher(url);
        if (!matcher.matches()) {
            return "";
        }
        if (matcher.groupCount() == 1) {
            String matchedDBServerType = matcher.group(1);
            urlDBServerType = Arrays.asList("db2", "hsqldb", "mariadb", "mysql", "oracle", "postgresql", "sqlite", "sqlserver").contains(matchedDBServerType) ? matchedDBServerType : null;
        } else {
            urlDBServerType = null;
        }
        if (Utility.isBlank(urlDBServerType)) {
            return "";
        }
        if ("mariadb".equals(urlDBServerType)) {
            return "mysql";
        }
        return urlDBServerType;
    }

    private static String getConnectionUrl(Connection connection) {
        String url;
        Objects.requireNonNull(connection, "No connection provided");
        try {
            url = connection.getMetaData().getURL();
        }
        catch (SQLException e) {
            LOGGER.log(Level.CONFIG, "Cannot get connection URL");
            return "";
        }
        return url;
    }

    private static boolean useMatchedDatabasePlugin(Connection connection, DatabaseServerType dbServerType) {
        String url = SchemaCrawlerUtility.getConnectionUrl(connection);
        if (Utility.isBlank((CharSequence)url)) {
            return true;
        }
        String urlDBServerType = SchemaCrawlerUtility.extractDatabaseServerTypeFromUrl(url);
        if (Utility.isBlank((CharSequence)urlDBServerType)) {
            return true;
        }
        boolean dbConnectorPresent = urlDBServerType.equalsIgnoreCase(dbServerType.getDatabaseSystemIdentifier());
        String withoutDatabasePlugin = PropertiesUtility.getSystemConfigurationProperty((String)"SC_WITHOUT_DATABASE_PLUGIN", (String)"");
        boolean useWithoutDatabasePlugin = urlDBServerType.equalsIgnoreCase(withoutDatabasePlugin);
        if (!dbConnectorPresent && !useWithoutDatabasePlugin) {
            throw new InternalRuntimeException(String.format("Add the SchemaCrawler database plugin for <%s> to the CLASSPATH for %n<%s>%nor set \"SC_WITHOUT_DATABASE_PLUGIN=%s\"%neither as an environmental variable or as a Java system property", urlDBServerType, url, urlDBServerType));
        }
        boolean useMatchedDatabasePlugin = dbConnectorPresent && !useWithoutDatabasePlugin;
        return useMatchedDatabasePlugin;
    }

    private SchemaCrawlerUtility() {
    }
}

