/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.analysis.associations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import schemacrawler.schema.Table;
import schemacrawler.tools.analysis.associations.WeakAssociationForeignKey;

public final class WeakAssociationsUtility {
    private static final String WEAK_ASSOCIATIONS_KEY = "schemacrawler.weak_associations";

    static void addWeakAssociationToTable(Table table, WeakAssociationForeignKey weakAssociation) {
        if (table != null && weakAssociation != null) {
            SortedSet tableWeakAssociations = (SortedSet)table.getAttribute(WEAK_ASSOCIATIONS_KEY, new TreeSet());
            tableWeakAssociations.add(weakAssociation);
            table.setAttribute(WEAK_ASSOCIATIONS_KEY, (Object)tableWeakAssociations);
        }
    }

    public static final Collection<WeakAssociationForeignKey> getWeakAssociations(Table table) {
        if (table == null) {
            return null;
        }
        SortedSet weakAssociations = (SortedSet)table.getAttribute(WEAK_ASSOCIATIONS_KEY, new TreeSet());
        ArrayList<WeakAssociationForeignKey> weakAssociationsList = new ArrayList<WeakAssociationForeignKey>(weakAssociations);
        weakAssociationsList.sort(Comparator.naturalOrder());
        return weakAssociationsList;
    }

    private WeakAssociationsUtility() {
    }
}

