/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.catalogloader;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import java.util.logging.Level;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.catalogloader.CatalogLoader;
import schemacrawler.tools.catalogloader.SchemaCrawlerCatalogLoader;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;

public final class CatalogLoaderRegistry {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger((String)CatalogLoaderRegistry.class.getName());
    private final Map<String, CatalogLoader> catalogLoaderRegistry = CatalogLoaderRegistry.loadCatalogLoaderRegistry();

    private static Map<String, CatalogLoader> loadCatalogLoaderRegistry() throws SchemaCrawlerException {
        HashMap<String, CatalogLoader> catalogLoaderRegistry = new HashMap<String, CatalogLoader>();
        try {
            ServiceLoader<CatalogLoader> serviceLoader = ServiceLoader.load(CatalogLoader.class);
            for (CatalogLoader catalogLoader : serviceLoader) {
                String databaseSystemIdentifier = catalogLoader.getDatabaseSystemIdentifier();
                try {
                    LOGGER.log(Level.CONFIG, (Supplier)new StringFormat("Loading catalog loader, %s=%s", new Object[]{databaseSystemIdentifier, catalogLoader.getClass().getName()}));
                    catalogLoaderRegistry.put(databaseSystemIdentifier, catalogLoader);
                }
                catch (Exception e) {
                    LOGGER.log(Level.CONFIG, (Supplier)new StringFormat("Could not load catalog loader, %s=%s", new Object[]{databaseSystemIdentifier, catalogLoader.getClass().getName()}), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            throw new SchemaCrawlerException("Could not load catalog loader registry", (Throwable)e);
        }
        return catalogLoaderRegistry;
    }

    public boolean hasDatabaseSystemIdentifier(String databaseSystemIdentifier) {
        return this.catalogLoaderRegistry.containsKey(databaseSystemIdentifier);
    }

    public CatalogLoader lookupCatalogLoader(String databaseSystemIdentifier) {
        if (this.hasDatabaseSystemIdentifier(databaseSystemIdentifier)) {
            return this.catalogLoaderRegistry.get(databaseSystemIdentifier);
        }
        return new SchemaCrawlerCatalogLoader();
    }
}

