/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.databaseconnector;

import schemacrawler.tools.databaseconnector.UserCredentials;
import sf.util.Utility;

public final class SingleUseUserCredentials
implements UserCredentials {
    private final String user;
    private final char[] password;
    private boolean isCleared;

    public SingleUseUserCredentials() {
        this.user = null;
        this.password = null;
    }

    public SingleUseUserCredentials(String user, String password) {
        this.user = user;
        this.password = (char[])(password == null ? null : password.toCharArray());
    }

    @Override
    public void clearPassword() {
        this.isCleared = true;
        if (this.hasPassword()) {
            for (int i = 0; i < this.password.length; ++i) {
                this.password[i] = '\u0000';
            }
        }
    }

    @Override
    public String getPassword() {
        if (this.isCleared) {
            throw new IllegalAccessError("Password has been cleared");
        }
        String passwordString = this.password == null ? null : new String(this.password);
        this.clearPassword();
        return passwordString;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public boolean hasPassword() {
        return !this.isCleared && this.password != null;
    }

    @Override
    public boolean hasUser() {
        return !Utility.isBlank((CharSequence)this.user);
    }

    public String toString() {
        return "UserCredentials [user=\"" + this.user + "\", password=\"*****\"]";
    }
}

