/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.base;

import java.io.IOException;
import java.io.PrintWriter;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import schemacrawler.schema.Column;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.IndexColumn;
import schemacrawler.schemacrawler.Identifiers;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.options.TextOutputFormat;
import schemacrawler.tools.text.base.BaseTextOptions;
import schemacrawler.tools.text.utility.DatabaseObjectColorMap;
import schemacrawler.tools.text.utility.HtmlFormattingHelper;
import schemacrawler.tools.text.utility.PlainTextFormattingHelper;
import schemacrawler.tools.text.utility.TextFormattingHelper;
import schemacrawler.tools.traversal.TraversalHandler;
import sf.util.Utility;

public abstract class BaseFormatter<O extends BaseTextOptions>
implements TraversalHandler {
    protected final O options;
    protected final OutputOptions outputOptions;
    protected final TextFormattingHelper formattingHelper;
    protected final DatabaseObjectColorMap colorMap;
    protected final Identifiers identifiers;
    protected final boolean printVerboseDatabaseInfo;
    private final PrintWriter out;

    protected BaseFormatter(O options, boolean printVerboseDatabaseInfo, OutputOptions outputOptions, String identifierQuoteString) throws SchemaCrawlerException {
        this.options = (BaseTextOptions)Objects.requireNonNull(options, "Options not provided");
        this.outputOptions = Objects.requireNonNull(outputOptions, "Output options not provided");
        this.colorMap = DatabaseObjectColorMap.initialize(((BaseTextOptions)options).isNoSchemaColors());
        this.printVerboseDatabaseInfo = !((BaseTextOptions)options).isNoInfo() && printVerboseDatabaseInfo;
        this.identifiers = Identifiers.identifiers().withIdentifierQuoteString(identifierQuoteString).withIdentifierQuotingStrategy(((BaseTextOptions)options).getIdentifierQuotingStrategy()).build();
        try {
            this.out = new PrintWriter(outputOptions.openNewOutputWriter(((BaseTextOptions)options).isAppendOutput()), true);
        }
        catch (IOException e) {
            throw new SchemaCrawlerException("Cannot open output writer", (Throwable)e);
        }
        TextOutputFormat outputFormat = TextOutputFormat.fromFormat(outputOptions.getOutputFormatValue());
        switch (outputFormat) {
            case html: {
                this.formattingHelper = new HtmlFormattingHelper(this.out, outputFormat);
                break;
            }
            default: {
                this.formattingHelper = new PlainTextFormattingHelper(this.out, outputFormat);
            }
        }
    }

    @Override
    public void end() throws SchemaCrawlerException {
        this.out.flush();
        this.out.close();
    }

    protected String columnNullable(String columnTypeName, boolean isNullable) {
        String columnNullable = isNullable ? "" : (Utility.isLowerCase((String)columnTypeName) ? " not null" : " NOT NULL");
        return columnNullable;
    }

    protected String formatTimestamp(TemporalAccessor timestamp) {
        return DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(timestamp);
    }

    protected boolean isColumnSignificant(Column column) {
        return column != null && (column instanceof IndexColumn || column.isPartOfPrimaryKey() || column.isPartOfForeignKey() || column.isPartOfIndex());
    }

    protected String nodeId(DatabaseObject dbObject) {
        if (dbObject == null) {
            return "";
        }
        List dbObjectLookupKey = dbObject.toUniqueLookupKey();
        return Utility.convertForComparison((String)dbObject.getName()) + "_" + Integer.toHexString(Arrays.hashCode(dbObjectLookupKey.toArray()));
    }
}

