/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.utility;

import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.logging.Level;
import schemacrawler.schemacrawler.Config;
import schemacrawler.tools.iosource.InputResource;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;

public class PropertiesUtility {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger((String)PropertiesUtility.class.getName());

    public static Config loadConfig(InputResource inputResource) {
        Properties properties = PropertiesUtility.loadProperties(inputResource);
        return new Config(properties);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Properties loadProperties(InputResource inputResource) {
        Objects.requireNonNull(inputResource, "No input resource provided");
        LOGGER.log(Level.INFO, (Supplier)new StringFormat("Loading properties from <%s>", new Object[]{inputResource}));
        try (Reader reader = inputResource.openNewInputReader(StandardCharsets.UTF_8);){
            Properties properties2 = new Properties();
            properties2.load(reader);
            Properties properties = properties2;
            return properties;
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, (Supplier)new StringFormat("Cannot load properties from <%s>", new Object[]{inputResource}), (Throwable)e);
            return new Properties();
        }
    }

    private PropertiesUtility() {
    }
}

