/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.utility;

import java.io.PrintWriter;
import schemacrawler.tools.options.TextOutputFormat;
import schemacrawler.tools.text.utility.BaseTextFormattingHelper;
import schemacrawler.tools.text.utility.TextFormattingHelper;
import schemacrawler.tools.text.utility.html.Entities;
import sf.util.Color;
import sf.util.IOUtility;
import sf.util.Utility;

public final class HtmlFormattingHelper
extends BaseTextFormattingHelper {
    private static final String HTML_HEADER = HtmlFormattingHelper.htmlHeader();
    private static final String HTML_FOOTER = "</body>" + System.lineSeparator() + "</html>";

    private static String htmlHeader() {
        StringBuilder styleSheet = new StringBuilder(4096);
        styleSheet.append(System.lineSeparator()).append(IOUtility.readResourceFully((String)"/sc.css")).append(System.lineSeparator()).append(IOUtility.readResourceFully((String)"/sc_output.css")).append(System.lineSeparator());
        String htmlHeaderTemplate = IOUtility.readResourceFully((String)"/html.header.txt");
        String htmlHeader = String.format(htmlHeaderTemplate, styleSheet);
        return htmlHeader;
    }

    public HtmlFormattingHelper(PrintWriter out, TextOutputFormat outputFormat) {
        super(out, outputFormat);
    }

    @Override
    public String createLeftArrow() {
        return "\u2190";
    }

    @Override
    public String createRightArrow() {
        return "\u2192";
    }

    @Override
    public String createWeakLeftArrow() {
        return "\u21dc";
    }

    @Override
    public String createWeakRightArrow() {
        return "\u21dd";
    }

    @Override
    public void writeDocumentEnd() {
        this.out.println(HTML_FOOTER);
    }

    @Override
    public void writeDocumentStart() {
        this.out.println(HTML_HEADER);
    }

    @Override
    public void writeHeader(TextFormattingHelper.DocumentHeaderType type, String header) {
        if (!Utility.isBlank((CharSequence)header) && type != null) {
            this.out.println(String.format("%s%n<%s>%s</%s>%n", type.getPrefix(), type.getHeaderTag(), header, type.getHeaderTag()));
        }
    }

    @Override
    public void writeObjectEnd() {
        this.out.append("</table>").println();
        this.out.println("<p>&#160;</p>");
        this.out.println();
    }

    @Override
    public void writeObjectNameRow(String id, String name, String description, Color backgroundColor) {
        StringBuilder buffer = new StringBuilder(1024);
        buffer.append("  <caption style='background-color: ").append(backgroundColor).append(";'>");
        if (!Utility.isBlank((CharSequence)name)) {
            buffer.append("<span");
            if (!Utility.isBlank((CharSequence)id)) {
                buffer.append(" id='").append(id).append("'");
            }
            buffer.append(" class='caption_name'>").append(Entities.escapeForXMLElement(name)).append("</span>");
        }
        if (!Utility.isBlank((CharSequence)description)) {
            buffer.append(" <span class='caption_description'>").append(Entities.escapeForXMLElement(description)).append("</span>");
        }
        buffer.append("</caption>").append(System.lineSeparator());
        this.out.println(buffer.toString());
    }

    @Override
    public void writeObjectStart() {
        this.out.println("<table>");
    }
}

