/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.databaseconnector;

import java.util.function.Predicate;
import java.util.regex.Pattern;
import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.DatabaseServerType;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.databaseconnector.DatabaseConnectionSource;
import schemacrawler.tools.databaseconnector.DatabaseConnector;
import schemacrawler.tools.databaseconnector.DatabaseConnectorOptions;
import schemacrawler.tools.iosource.EmptyInputResource;

final class UnknownDatabaseConnector
extends DatabaseConnector {
    private static final Pattern[] patterns = new Pattern[]{Pattern.compile("jdbc:db2:.*"), Pattern.compile("jdbc:(mysql|mariadb):.*"), Pattern.compile("jdbc:oracle:.*"), Pattern.compile("jdbc:postgresql:.*"), Pattern.compile("jdbc:sqlite:.*"), Pattern.compile("jdbc:sqlserver:.*")};

    UnknownDatabaseConnector() {
        super(DatabaseServerType.UNKNOWN, new EmptyInputResource(), (informationSchemaViewsBuilder, connection) -> informationSchemaViewsBuilder.fromResourceFolder("/db2.information_schema"));
    }

    @Override
    public DatabaseConnectionSource newDatabaseConnectionSource(DatabaseConnectorOptions databaseConnectorOptions) throws SchemaCrawlerException {
        DatabaseConnectionSource databaseConnectionSource = super.newDatabaseConnectionSource(databaseConnectorOptions);
        String withoutDatabasePlugin = Config.getSystemConfigurationProperty((String)"SC_WITHOUT_DATABASE_PLUGIN", (String)Boolean.FALSE.toString());
        if (!Boolean.valueOf(withoutDatabasePlugin).booleanValue()) {
            String url = databaseConnectionSource.getConnectionUrl();
            for (Pattern pattern : patterns) {
                if (!pattern.matcher(url).matches()) continue;
                throw new SchemaCrawlerException(String.format("SchemaCrawler database plugin should be on the CLASSPATH for <%s>", url));
            }
        }
        return databaseConnectionSource;
    }

    @Override
    protected Predicate<String> supportsUrlPredicate() {
        return url -> false;
    }
}

