/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.executable.BaseSchemaCrawlerCommand;
import schemacrawler.tools.executable.CommandRegistry;
import schemacrawler.tools.executable.SchemaCrawlerCommand;
import schemacrawler.tools.options.OutputOptions;
import sf.util.SchemaCrawlerLogger;

abstract class BaseCommandChain
extends BaseSchemaCrawlerCommand {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger((String)BaseCommandChain.class.getName());
    private final CommandRegistry commandRegistry = CommandRegistry.getCommandRegistry();
    private final List<SchemaCrawlerCommand> scCommands = new ArrayList<SchemaCrawlerCommand>();

    BaseCommandChain(String command) throws SchemaCrawlerException {
        super(command);
    }

    @Override
    public void checkAvailability() throws Exception {
        this.checkAvailabilityChain();
    }

    final SchemaCrawlerCommand addNextAndConfigureForExecution(String command, OutputOptions outputOptions) throws SchemaCrawlerException {
        try {
            SchemaCrawlerCommand scCommand = this.commandRegistry.configureNewCommand(command, this.schemaCrawlerOptions, this.additionalConfiguration, outputOptions);
            if (scCommand == null) {
                return null;
            }
            scCommand.setAdditionalConfiguration(this.additionalConfiguration);
            scCommand.setCatalog(this.catalog);
            scCommand.setConnection(this.connection);
            scCommand.setIdentifiers(this.identifiers);
            this.scCommands.add(scCommand);
            return scCommand;
        }
        catch (SchemaCrawlerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchemaCrawlerException(String.format("Cannot chain command, unknown command <%s>", command));
        }
    }

    final void checkAvailabilityChain() throws Exception {
        if (this.scCommands.isEmpty()) {
            LOGGER.log(Level.INFO, "No command to execute");
            return;
        }
        for (SchemaCrawlerCommand scCommand : this.scCommands) {
            scCommand.checkAvailability();
        }
    }

    final void executeChain() throws Exception {
        if (this.scCommands.isEmpty()) {
            LOGGER.log(Level.INFO, "No command to execute");
            return;
        }
        for (SchemaCrawlerCommand scCommand : this.scCommands) {
            scCommand.execute();
        }
    }

    final void initializeChain() throws Exception {
        if (this.scCommands.isEmpty()) {
            LOGGER.log(Level.INFO, "No command to initialize");
            return;
        }
        for (SchemaCrawlerCommand scCommand : this.scCommands) {
            scCommand.initialize();
        }
    }
}

