/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.operation;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Level;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.Identifiers;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.QueryUtility;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.executable.BaseSchemaCrawlerCommand;
import schemacrawler.tools.options.TextOutputFormat;
import schemacrawler.tools.text.operation.DataTextFormatter;
import schemacrawler.tools.text.operation.Operation;
import schemacrawler.tools.text.operation.OperationOptions;
import schemacrawler.tools.text.operation.OperationOptionsBuilder;
import schemacrawler.tools.traversal.DataTraversalHandler;
import schemacrawler.utility.NamedObjectSort;
import sf.util.DatabaseUtility;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;

public final class OperationCommand
extends BaseSchemaCrawlerCommand {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger((String)OperationCommand.class.getName());
    private OperationOptions operationOptions;

    public OperationCommand(String command) {
        super(command);
    }

    @Override
    public void checkAvailability() throws Exception {
    }

    @Override
    public void initialize() throws Exception {
        super.initialize();
        this.loadOperationOptions();
    }

    @Override
    public void execute() throws Exception {
        this.checkCatalog();
        if (!this.isOutputFormatSupported()) {
            LOGGER.log(Level.INFO, (Supplier)new StringFormat("Output format <%s> not supported for command <%s>", new Object[]{this.outputOptions.getOutputFormatValue(), this.getCommand()}));
            return;
        }
        DataTraversalHandler handler = this.getDataTraversalHandler();
        Query query = this.getQuery();
        handler.begin();
        handler.handleInfoStart();
        handler.handle(this.catalog.getDatabaseInfo());
        handler.handle(this.catalog.getJdbcDriverInfo());
        handler.handleInfoEnd();
        if (query.isQueryOver()) {
            String identifierQuoteString = this.identifiers.getIdentifierQuoteString();
            Identifiers identifiers = Identifiers.identifiers().withIdentifierQuoteString(identifierQuoteString).build();
            try (Statement statement = DatabaseUtility.createStatement((Connection)this.connection);){
                for (Table table : this.getSortedTables(this.catalog)) {
                    boolean isAlphabeticalSortForTableColumns = this.operationOptions.isAlphabeticalSortForTableColumns();
                    try {
                        ResultSet results = QueryUtility.executeAgainstTable((Query)query, (Statement)statement, (Table)table, (boolean)isAlphabeticalSortForTableColumns, (Identifiers)identifiers);
                        Throwable throwable = null;
                        try {
                            handler.handleData(table, results);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (results == null) continue;
                            if (throwable != null) {
                                try {
                                    results.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            results.close();
                        }
                    }
                    catch (SQLException e) {
                        LOGGER.log(Level.WARNING, (Supplier)new StringFormat("Bad operation for table <%s>", new Object[]{table}), (Throwable)e);
                    }
                }
            }
        }
        String sql = query.getQuery();
        try (Statement statement = DatabaseUtility.createStatement((Connection)this.connection);
             ResultSet results = DatabaseUtility.executeSql((Statement)statement, (String)sql);){
            handler.handleData(query, results);
        }
        handler.end();
    }

    @Override
    public boolean usesConnection() {
        return true;
    }

    public OperationOptions getOperationOptions() {
        return this.operationOptions;
    }

    public final void setOperationOptions(OperationOptions operationOptions) {
        this.operationOptions = Objects.requireNonNull(operationOptions, "No operation options provided");
    }

    private DataTraversalHandler getDataTraversalHandler() throws SchemaCrawlerException {
        Operation operation = this.getOperation();
        TextOutputFormat outputFormat = TextOutputFormat.fromFormat(this.outputOptions.getOutputFormatValue());
        String identifierQuoteString = this.identifiers.getIdentifierQuoteString();
        DataTextFormatter formatter = new DataTextFormatter(operation, this.operationOptions, this.outputOptions, identifierQuoteString);
        return formatter;
    }

    private Operation getOperation() {
        Operation operation = null;
        try {
            operation = Operation.valueOf(this.command);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            operation = null;
        }
        return operation;
    }

    private Query getQuery() {
        Query query;
        Operation operation = this.getOperation();
        if (operation == null) {
            String queryName = this.command;
            String queryString = this.additionalConfiguration.get((Object)queryName);
            query = new Query(queryName, queryString);
        } else {
            query = operation.getQuery();
        }
        return query;
    }

    private List<? extends Table> getSortedTables(Catalog catalog) {
        ArrayList tables = new ArrayList(catalog.getTables());
        tables.sort(NamedObjectSort.getNamedObjectSort((boolean)this.operationOptions.isAlphabeticalSortForTables()));
        return tables;
    }

    private boolean isOutputFormatSupported() {
        String outputFormatValue = this.outputOptions.getOutputFormatValue();
        boolean isOutputFormatSupported = TextOutputFormat.isSupportedFormat(outputFormatValue);
        return isOutputFormatSupported;
    }

    private void loadOperationOptions() {
        if (this.operationOptions == null) {
            this.operationOptions = OperationOptionsBuilder.builder().fromConfig(this.additionalConfiguration).toOptions();
        }
    }
}

